"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * adgm controller
 */
const strapi_1 = require("@strapi/strapi");
exports.default = strapi_1.factories.createCoreController("api::adgm.adgm", ({ strapi }) => ({
    async createAdgm(ctx, next) {
        try {
            const data = await strapi
                .service("api::adgm.adgm")
                .createAdgm(ctx.request.body);
            return ctx.send(data);
        }
        catch (error) {
            console.log(error);
            return error;
        }
    },
    async updateAdgm(ctx, next) {
        try {
            const { id } = ctx.params;
            if (!id) {
                return ctx.badRequest("ID is required");
            }
            const data = await strapi
                .service("api::adgm.adgm")
                .updateAdgm(id, ctx.request.body);
            return ctx.send(data);
        }
        catch (error) {
            console.log(error);
            return error;
        }
    },
    findAllAdgms: async (ctx) => {
        try {
            const data = await strapi
                .service("api::adgm.adgm")
                .findAllAdgms(ctx.request.query);
            return ctx.send(data);
        }
        catch (error) {
            console.log(error);
        }
    },
    findExportData: async (ctx) => {
        try {
            const data = await strapi.service("api::adgm.adgm").findExportData();
            return ctx.send(data);
        }
        catch (error) {
            console.log(error);
        }
    },
    getByUUID: async (ctx) => {
        try {
            const { id } = ctx.params;
            if (!id) {
                return ctx.badRequest("ID is required");
            }
            const data = await strapi
                .service("api::adgm.adgm")
                .getByUUID(String(id));
            return ctx.send(data);
        }
        catch (error) {
            console.log(error);
        }
    },
    softDelete: async (ctx) => {
        const { id } = ctx.params;
        if (!id) {
            return ctx.badRequest("ID is required");
        }
        try {
            const data = await strapi.service("api::adgm.adgm").softDelete(id);
            return ctx.send(data);
        }
        catch (error) {
            console.log(error);
        }
    },
    adgmLogin: async (ctx) => {
        try {
            const data = await strapi
                .service("api::adgm.adgm")
                .adgmLogin(ctx.request.body);
            return ctx.send(data);
        }
        catch (error) {
            console.log(error);
        }
    },
}));
