"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * adgm router
 */
const strapi_1 = require("@strapi/strapi");
const defaultRouter = strapi_1.factories.createCoreRouter("api::adgm.adgm");
const customRouter = (innerRouter, extraRoutes = []) => {
    let routes;
    return {
        get prefix() {
            return innerRouter.prefix;
        },
        get routes() {
            if (!routes)
                routes = innerRouter.routes.concat(extraRoutes);
            return routes;
        },
    };
};
const extraRoutes = [
    {
        method: "POST",
        path: "/createAdgm",
        handler: "adgm.createAdgm",
        config: {
            policies: [],
            middlewares: [],
        },
    },
    {
        method: "PUT",
        path: "/updateAdgm/:id",
        handler: "adgm.updateAdgm",
        config: {
            policies: [],
            middlewares: [],
        },
    },
    {
        method: "GET",
        path: "/adgms/getByUUID/:id",
        handler: "api::adgm.adgm.getByUUID",
        config: {
            auth: false,
            policies: [],
            middlewares: [],
        },
    },
    {
        method: "GET",
        path: "/adgm/all",
        handler: "adgm.findAllAdgms",
        config: {
            auth: false,
            policies: [],
            middlewares: [],
        },
    },
    {
        method: "GET",
        path: "/adgm/export",
        handler: "adgm.findExportData",
        config: {
            auth: false,
            policies: [],
            middlewares: [],
        },
    },
    {
        method: "GET",
        path: "/adgm/remove/:id",
        handler: "adgm.softDelete",
        config: {
            auth: false,
            policies: [],
            middlewares: [],
        },
    },
    {
        method: "POST",
        path: "/adgm/login",
        handler: "adgm.adgmLogin",
        config: {
            auth: false,
            policies: [],
            middlewares: [],
        },
    },
];
exports.default = customRouter(defaultRouter, extraRoutes);
