"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const strapi_1 = require("@strapi/strapi");
const moment_1 = __importDefault(require("moment"));
exports.default = strapi_1.factories.createCoreController("api::agenda-session.agenda-session", ({ strapi }) => ({
    datewiseSessionsSpeakers: async (ctx) => {
        try {
            const data = await strapi
                .service("api::agenda-session.agenda-session")
                .datewiseSessionsSpeakers();
            return ctx.send(data);
        }
        catch (error) {
            console.log(error);
        }
    },
    softDelete: async (ctx) => {
        try {
            const { id } = ctx.params;
            if (!id) {
                return ctx.badRequest("ID is required");
            }
            const data = await strapi
                .service("api::agenda-session.agenda-session")
                .softDelete(id);
            return ctx.send(data);
        }
        catch (error) {
            console.log(error);
        }
    },
    findAllSessions: async (ctx) => {
        try {
            const data = await strapi
                .service("api::agenda-session.agenda-session")
                .findAllSessions(ctx.request.query);
            return ctx.send(data);
        }
        catch (error) {
            console.log(error);
        }
    },
    findOneSession: async (ctx) => {
        try {
            const { id } = ctx.params;
            if (!id) {
                return ctx.badRequest("ID is required");
            }
            const data = await strapi
                .service("api::agenda-session.agenda-session")
                .findOneSession(id, ctx.request.query);
            return ctx.send(data);
        }
        catch (error) {
            console.log(error);
        }
    },
    findExportData: async (ctx) => {
        try {
            const data = await strapi
                .service("api::agenda-session.agenda-session")
                .findExportData();
            return ctx.send(data);
        }
        catch (error) {
            console.log(error);
        }
    },
    generateSessionICSFile: async (ctx) => {
        try {
            const { sessionId } = ctx.params;
            if (!sessionId) {
                return ctx.badRequest("ID is required");
            }
            const data = await strapi
                .service("api::agenda-session.agenda-session")
                .generateSessionICSFile(sessionId);
            const DTSTAMP = (0, moment_1.default)().unix();
            ctx.res.setHeader('Content-Type', 'text/calendar');
            ctx.set({
                'Content-Type': 'text/calendar',
                'Content-Disposition': `attachment; filename="session-reminder-${DTSTAMP}.ics"`,
            });
            return ctx.send(data);
        }
        catch (error) {
            console.log(error);
        }
    },
    findSessions: async (ctx) => {
        try {
            const data = await strapi
                .service("api::agenda-session.agenda-session")
                .findSessions(ctx.request.query);
            return ctx.send(data);
        }
        catch (error) {
            console.log(error);
        }
    },
}));
