"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const { createCoreRouter } = require("@strapi/strapi").factories;
const defaultRouter = createCoreRouter("api::agenda-session.agenda-session");
const customRouter = (innerRouter, extraRoutes = []) => {
    let routes;
    return {
        get prefix() {
            return innerRouter.prefix;
        },
        get routes() {
            if (!routes)
                routes = innerRouter.routes.concat(extraRoutes);
            return routes;
        },
    };
};
const extraRoutes = [
    {
        method: "GET",
        path: "/agenda-session/speakersData",
        handler: "api::agenda-session.agenda-session.datewiseSessionsSpeakers",
        config: {
            auth: false,
            policies: [],
            middlewares: [],
        },
    },
    {
        method: "GET",
        path: "/agenda-sessions/findOne/:id",
        handler: "api::agenda-session.agenda-session.findOneSession",
        config: {
            auth: false,
            policies: [],
            middlewares: [],
        },
    },
    {
        method: "GET",
        path: "/agenda-sessions/remove/:id",
        handler: "api::agenda-session.agenda-session.softDelete",
        config: {
            auth: false,
            policies: [],
            middlewares: [],
        },
    },
    {
        method: "GET",
        path: "/agenda-session/all",
        handler: "agenda-session.findAllSessions",
        config: {
            auth: false,
            policies: [],
            middlewares: [],
        },
    },
    {
        method: "GET",
        path: "/agenda-session/export",
        handler: "agenda-session.findExportData",
        config: {
            auth: false,
            policies: [],
            middlewares: [],
        },
    },
    {
        method: "GET",
        path: "/agenda-session/generateICS/:sessionId",
        handler: "agenda-session.generateSessionICSFile",
        config: {
            auth: false,
            policies: [],
            middlewares: [],
        },
    },
    {
        method: "GET",
        path: "/adfw-2024/sessions/all",
        handler: "agenda-session.findSessions",
        config: {
            auth: false,
            policies: [],
            middlewares: [],
        },
    },
];
exports.default = customRouter(defaultRouter, extraRoutes);
