"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const strapi_1 = require("@strapi/strapi");
exports.default = strapi_1.factories.createCoreController("api::agenda.agenda", ({ strapi }) => ({
    picker: async (ctx) => {
        try {
            const { query } = ctx.request.query;
            const data = await strapi
                .service("api::agenda.agenda")
                .picker(query);
            return ctx.send(data);
        }
        catch (error) {
            console.log(error);
        }
    },
    createAgenda: async (ctx) => {
        var _a, _b;
        try {
            const userId = (_b = (_a = ctx === null || ctx === void 0 ? void 0 : ctx.state) === null || _a === void 0 ? void 0 : _a.user) === null || _b === void 0 ? void 0 : _b.id;
            const data = await strapi
                .service("api::agenda.agenda")
                .createAgenda(userId, ctx.request.body);
            return ctx.send(data);
        }
        catch (error) {
            console.log(error);
        }
    },
    updateAgenda: async (ctx) => {
        var _a, _b;
        try {
            const userId = (_b = (_a = ctx === null || ctx === void 0 ? void 0 : ctx.state) === null || _a === void 0 ? void 0 : _a.user) === null || _b === void 0 ? void 0 : _b.id;
            const { id } = ctx.params;
            if (!id) {
                return ctx.badRequest("ID is required");
            }
            const data = await strapi
                .service("api::agenda.agenda")
                .updateAgenda(id, ctx.request.body, userId);
            return ctx.send(data);
        }
        catch (error) {
            console.log(error);
        }
    },
    softDelete: async (ctx) => {
        try {
            const { id } = ctx.params;
            if (!id) {
                return ctx.badRequest("ID is required");
            }
            const data = await strapi.service("api::agenda.agenda").softDelete(id);
            return ctx.send(data);
        }
        catch (error) {
            console.log(error);
        }
    },
    getAgendaDetails: async (ctx) => {
        try {
            const { id } = ctx.params;
            if (!id) {
                return ctx.badRequest("ID is required");
            }
            const data = await strapi
                .service("api::agenda.agenda")
                .getAgendaDetails(id);
            return ctx.send(data);
        }
        catch (error) {
            console.log(error);
        }
    },
    getAgendaByDate: async (ctx) => {
        try {
            const data = await strapi
                .service("api::agenda.agenda")
                .getAgendaByDate(ctx.request.query);
            return ctx.send(data);
        }
        catch (error) {
            console.log(error);
        }
    },
    findAllAgendas: async (ctx) => {
        try {
            const data = await strapi
                .service("api::agenda.agenda")
                .findAllAgendas(ctx.request.query);
            return ctx.send(data);
        }
        catch (error) {
            console.log(error);
        }
    },
    findExportData: async (ctx) => {
        try {
            const data = await strapi
                .service("api::agenda.agenda")
                .findExportData();
            return ctx.send(data);
        }
        catch (error) {
            console.log(error);
        }
    },
    globalSearch: async (ctx) => {
        try {
            const data = await strapi
                .service("api::agenda.agenda")
                .globalSearch(ctx.request.query);
            return ctx.send(data);
        }
        catch (error) {
            console.log(error);
        }
    },
    findAllInitialAppData: async (ctx) => {
        try {
            const data = await strapi
                .service("api::agenda.agenda")
                .findAllInitialAppData(ctx.request.query);
            return ctx.send(data);
        }
        catch (error) {
            console.log(error);
        }
    },
}));
