"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const { createCoreRouter } = require("@strapi/strapi").factories;
const defaultRouter = createCoreRouter("api::agenda.agenda");
const customRouter = (innerRouter, extraRoutes = []) => {
    let routes;
    return {
        get prefix() {
            return innerRouter.prefix;
        },
        get routes() {
            if (!routes)
                routes = innerRouter.routes.concat(extraRoutes);
            return routes;
        },
    };
};
const extraRoutes = [
    {
        method: "GET",
        path: "/agenda/picker",
        handler: "agenda.picker",
        config: {
            auth: false,
            policies: [],
            middlewares: [],
        },
    },
    ,
    {
        method: "POST",
        path: "/agendas/create",
        handler: "agenda.createAgenda",
        config: {
            policies: [],
            middlewares: [
            // {
            //   name: "global::role-access",
            //   config: {
            //     allowedRoles: [6],
            //     policies: [],
            //   },
            // },
            ],
        },
    },
    {
        method: "PUT",
        path: "/agendas/update/:id",
        handler: "agenda.updateAgenda",
        config: {
            policies: [],
            middlewares: [
            // {
            //   name: "global::role-access",
            //   config: {
            //     allowedRoles: [6],
            //     policies: [],
            //   },
            // },
            ],
        },
    },
    {
        method: "GET",
        path: "/agendas/remove/:id",
        handler: "api::agenda.agenda.softDelete",
        config: {
            auth: false,
            policies: [],
            middlewares: [],
        },
    },
    {
        method: "GET",
        path: "/agenda/byDate",
        handler: "api::agenda.agenda.getAgendaByDate",
        config: {
            auth: false,
            policies: [],
            middlewares: [],
        },
    },
    {
        method: "GET",
        path: "/agenda/details/:id",
        handler: "api::agenda.agenda.getAgendaDetails",
        config: {
            auth: false,
            policies: [],
            middlewares: [],
        },
    },
    {
        method: "GET",
        path: "/agenda/all",
        handler: "agenda.findAllAgendas",
        config: {
            auth: false,
            policies: [],
            middlewares: [],
        },
    },
    {
        method: "GET",
        path: "/agenda/export",
        handler: "agenda.findExportData",
        config: {
            auth: false,
            policies: [],
            middlewares: [],
        },
    },
    {
        method: "GET",
        path: "/global-search",
        handler: "agenda.globalSearch",
        config: {
            auth: false,
            policies: [],
            middlewares: [],
        },
    },
    {
        method: "GET",
        path: "/findAllData",
        handler: "agenda.findAllInitialAppData",
        config: {
            auth: false,
            policies: [],
            middlewares: [],
        },
    },
];
exports.default = customRouter(defaultRouter, extraRoutes);
