"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const { createCoreRouter } = require("@strapi/strapi").factories;
const defaultRouter = createCoreRouter("api::artist.artist");
const customRouter = (innerRouter, extraRoutes = []) => {
    let routes;
    return {
        get prefix() {
            return innerRouter.prefix;
        },
        get routes() {
            if (!routes)
                routes = innerRouter.routes.concat(extraRoutes);
            return routes;
        },
    };
};
const extraRoutes = [
    {
        method: "GET",
        path: "/artist/findAllByLocation",
        handler: "artist.findArtistsByLocations",
        config: {
            auth: false,
            policies: [],
            middlewares: [],
        },
    },
    {
        method: "GET",
        path: "/artists/remove/:id",
        handler: "artist.softDelete",
        config: {
            auth: false,
            policies: [],
            middlewares: [],
        },
    },
];
exports.default = customRouter(defaultRouter, extraRoutes);
