"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const strapi_1 = require("@strapi/strapi");
const dataResponse_dto_1 = require("../../../shared/dto/dataResponse.dto");
exports.default = strapi_1.factories.createCoreService("api::artist.artist", ({ strapi }) => ({
    async findArtistsByLocations() {
        try {
            const artists = await strapi.db.connection('venues as v')
                .select([
                'v.name as location',
                strapi.db.connection.raw(`
            JSON_AGG(
              DISTINCT jsonb_build_object(
                'name', a.name,
                'image', a.image,
                'bio', a.bio,
                'time', a.time,
                'date', a.date
              )
            ) as artists
          `),
            ])
                .join('artists_location_links as al', 'al.venue_id', 'v.id')
                .join('artists as a', 'a.id', 'al.artist_id')
                .where({
                'v.is_deleted': false,
                'a.is_deleted': false
            })
                .groupBy('v.id')
                .havingRaw('COUNT(DISTINCT a.id) > 0')
                .orderBy('v.id', 'desc');
            artists.forEach((venue) => {
                if (venue.artists && Array.isArray(venue.artists)) {
                    venue.artists.sort((a, b) => {
                        const dateA = new Date(a.date);
                        const dateB = new Date(b.date);
                        if (dateA.getTime() === dateB.getTime()) {
                            const cleanTimeA = a.time.replace(/ Onwards$/i, '').trim();
                            const cleanTimeB = b.time.replace(/ Onwards$/i, '').trim();
                            return cleanTimeA.localeCompare(cleanTimeB);
                        }
                        return dateA.getTime() - dateB.getTime();
                    });
                }
            });
            return new dataResponse_dto_1.DataResponseDto(artists, 'entertainers data fetched successfully');
        }
        catch (error) {
            console.log(error);
            return new dataResponse_dto_1.DataResponseDto(null, "Something went wrong in our end please contact system administrator");
        }
    },
    async softDelete(id) {
        try {
            const data = await strapi.db
                .query("api::artist.artist")
                .update({
                where: { id, is_deleted: false },
                data: {
                    is_deleted: true,
                },
            });
            if (data) {
                return new dataResponse_dto_1.DataResponseDto(data, "artist deleted successfully");
            }
            else {
                return new dataResponse_dto_1.DataResponseDto(null);
            }
        }
        catch (error) {
            console.log(error);
            return new dataResponse_dto_1.DataResponseDto(null, "Something went wrong in our end please contact system administrator");
        }
    }
}));
