module.exports = {
    async Login(ctx, next) {
        try {
            const { email, password } = ctx.request.body;
            const data = await strapi
                .service("api::auth.auth")
                .Login(email, password);
            ctx.send(data);
        }
        catch (err) {
            console.log("err", err);
            ctx.badRequest("Bad request", { moreDetails: err });
        }
    },
    async register(ctx, next) {
        try {
            const data = await strapi
                .service("api::auth.auth")
                .register(ctx.request.body);
            ctx.send(data);
        }
        catch (err) {
            console.log("err", err);
            ctx.badRequest("Bad request", { moreDetails: err });
        }
    },
    async userLogin(ctx, next) {
        try {
            const data = await strapi
                .service("api::auth.auth")
                .userLogin(ctx.request.body);
            ctx.send(data);
        }
        catch (err) {
            console.log("err", err);
            ctx.badRequest("Bad request", { moreDetails: err });
        }
    },
    async userLogout(ctx, next) {
        try {
            const { ticketNumber, fcmToken, sessionId } = ctx.request.body;
            if (!ticketNumber) {
                ctx.badRequest("Provide all required fields");
            }
            const data = await strapi
                .service("api::auth.auth")
                .userLogout(ticketNumber, fcmToken, sessionId);
            ctx.send(data);
        }
        catch (err) {
            console.log("err", err);
            ctx.badRequest("Bad request", { moreDetails: err });
        }
    },
    async updateUserDetails(ctx, next) {
        try {
            const { id } = ctx.params;
            if (!id) {
                return ctx.badRequest("ID is required");
            }
            const data = await strapi
                .service("api::auth.auth")
                .updateUserDetails(id, ctx.request.body);
            ctx.send(data);
        }
        catch (err) {
            console.log("err", err);
            ctx.badRequest("Bad request", { moreDetails: err });
        }
    },
    async findUsers(ctx, next) {
        try {
            const data = await strapi
                .service("api::auth.auth")
                .findUsers(ctx.request.query);
            ctx.send(data);
        }
        catch (err) {
            console.log("err", err);
            ctx.badRequest("Bad request", { moreDetails: err });
        }
    },
    async findExportData(ctx, next) {
        try {
            const data = await strapi
                .service("api::auth.auth")
                .findExportData();
            ctx.send(data);
        }
        catch (err) {
            console.log("err", err);
            ctx.badRequest("Bad request", { moreDetails: err });
        }
    },
    async findOneUser(ctx, next) {
        try {
            const { id } = ctx.params;
            if (!id) {
                return ctx.badRequest("ID is required");
            }
            const data = await strapi.service("api::auth.auth").findOneUser(id);
            ctx.send(data);
        }
        catch (err) {
            console.log("err", err);
            ctx.badRequest("Bad request", { moreDetails: err });
        }
    },
    softDelete: async (ctx) => {
        try {
            const { id } = ctx.params;
            if (!id) {
                return ctx.badRequest("ID is required");
            }
            const data = await strapi.service("api::auth.auth").softDelete(id);
            return ctx.send(data);
        }
        catch (error) {
            console.log(error);
        }
    },
    async updateUser(ctx, next) {
        try {
            const { id } = ctx.params;
            if (!id) {
                return ctx.badRequest("ID is required");
            }
            const data = await strapi
                .service("api::auth.auth")
                .updateUser(id, ctx.request.body);
            ctx.send(data);
        }
        catch (err) {
            console.log("err", err);
            ctx.badRequest("Bad request", { moreDetails: err });
        }
    },
};
