module.exports = {
    routes: [
        {
            method: "POST",
            path: "/login",
            handler: "auth.Login",
            config: {
                policies: [],
                middlewares: [],
            },
        },
        {
            method: "POST",
            path: "/user/create",
            handler: "auth.register",
            config: {
                policies: [],
                middlewares: [],
            },
        },
        {
            method: "POST",
            path: "/user/login",
            handler: "auth.userLogin",
            config: {
                policies: [],
                middlewares: [],
            },
        },
        {
            method: "POST",
            path: "/user/logout",
            handler: "auth.userLogout",
            config: {
                policies: [],
                middlewares: [],
            },
        },
        {
            method: "PUT",
            path: "/ticket-user/update/:id",
            handler: "auth.updateUserDetails",
            config: {
                policies: [],
                middlewares: [],
            },
        },
        {
            method: "GET",
            path: "/users/all",
            handler: "auth.findUsers",
            config: {
                policies: [],
                middlewares: [],
            },
        },
        {
            method: "GET",
            path: "/users/export",
            handler: "auth.findExportData",
            config: {
                policies: [],
                middlewares: [],
            },
        },
        {
            method: "GET",
            path: "/users/find/:id",
            handler: "auth.findOneUser",
            config: {
                policies: [],
                middlewares: [],
            },
        },
        {
            method: "GET",
            path: "/users/remove/:id",
            handler: "auth.softDelete",
            config: {
                auth: false,
                policies: [],
                middlewares: [],
            },
        },
        {
            method: "PUT",
            path: "/user/update/:id",
            handler: "auth.updateUser",
            config: {
                auth: false,
                policies: [],
                middlewares: [],
            },
        },
    ],
};
