"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const strapi_1 = require("@strapi/strapi");
exports.default = strapi_1.factories.createCoreController("api::banner.banner", ({ strapi }) => ({
    updatePosition: async (ctx) => {
        try {
            const { id } = ctx.params;
            const { position, userId } = ctx.request.body;
            if (!id) {
                return ctx.badRequest("ID is required");
            }
            if (!position) {
                return ctx.badRequest("Position is required");
            }
            const data = await strapi
                .service("api::banner.banner")
                .updatePosition(id, position, userId);
            return ctx.send(data);
        }
        catch (error) {
            console.log(error);
        }
    },
    softDelete: async (ctx) => {
        try {
            const { id } = ctx.params;
            if (!id) {
                return ctx.badRequest("ID is required");
            }
            const data = await strapi.service("api::banner.banner").softDelete(id);
            return ctx.send(data);
        }
        catch (error) {
            console.log(error);
        }
    },
}));
