"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const strapi_1 = require("@strapi/strapi");
const defaultRouter = strapi_1.factories.createCoreRouter('api::banner.banner');
const customRouter = (innerRouter, extraRoutes = []) => {
    let routes;
    return {
        get prefix() {
            return innerRouter.prefix;
        },
        get routes() {
            if (!routes)
                routes = innerRouter.routes.concat(extraRoutes);
            return routes;
        },
    };
};
const extraRoutes = [
    {
        method: "PUT",
        path: "/banners/updateOrder/:id",
        handler: "banner.updatePosition",
        config: {
            auth: false,
            policies: [],
            middlewares: [],
        },
    },
    {
        method: "GET",
        path: "/banners/remove/:id",
        handler: "banner.softDelete",
        config: {
            auth: false,
            policies: [],
            middlewares: [],
        },
    },
];
exports.default = customRouter(defaultRouter, extraRoutes);
