"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const strapi_1 = require("@strapi/strapi");
const dataResponse_dto_1 = require("../../../shared/dto/dataResponse.dto");
exports.default = strapi_1.factories.createCoreService("api::banner.banner", ({ strapi }) => ({
    async updatePosition(id, position, userId) {
        try {
            const bannerData = await strapi.query('api::banner.banner').findOne({ where: { id } });
            if (!bannerData) {
                return new dataResponse_dto_1.DataResponseDto(null, 'Banner not found');
            }
            const currentOrder = bannerData.position;
            if (currentOrder === position) {
                return new dataResponse_dto_1.DataResponseDto(null, 'Banner already in the requested order');
            }
            if (currentOrder < position) {
                const bannersToUpdate = await strapi.query('api::banner.banner').findMany({
                    where: { position: { $gte: currentOrder + 1, $lte: position } },
                });
                await Promise.all(bannersToUpdate.map(async (banner) => {
                    await strapi.query('api::banner.banner').update({
                        where: { id: banner.id },
                        data: { position: banner.position - 1, modifiedBy: userId },
                    });
                }));
            }
            else if (currentOrder > position) {
                const bannersToUpdate = await strapi.query('api::banner.banner').findMany({
                    where: { position: { $gte: position, $lte: currentOrder - 1 } },
                });
                await Promise.all(bannersToUpdate.map(async (banner) => {
                    await strapi.query('api::banner.banner').update({
                        where: { id: banner.id },
                        data: { position: banner.position + 1,
                            modifiedBy: userId
                        },
                    });
                }));
            }
            const updatedBanner = await strapi.query('api::banner.banner').update({
                where: { id },
                data: { position, modifiedBy: userId },
            });
            return new dataResponse_dto_1.DataResponseDto(updatedBanner, 'Banner updated successfully');
        }
        catch (error) {
            console.log(error);
            return new dataResponse_dto_1.DataResponseDto(null, "Something went wrong in our end please contact system administrator");
        }
    },
    async softDelete(id) {
        try {
            const data = await strapi.db.query("api::banner.banner").update({
                where: { id, is_deleted: false },
                data: {
                    is_deleted: true,
                },
            });
            if (data) {
                return new dataResponse_dto_1.DataResponseDto(data, "Banner deleted successfully");
            }
            else {
                return new dataResponse_dto_1.DataResponseDto(null);
            }
        }
        catch (error) {
            console.log(error);
            return new dataResponse_dto_1.DataResponseDto(null, "Something went wrong in our end please contact system administrator");
        }
    },
}));
