"use strict";
/**
 * country controller
 */
Object.defineProperty(exports, "__esModule", { value: true });
const strapi_1 = require("@strapi/strapi");
exports.default = strapi_1.factories.createCoreController("api::country.country", ({ strapi }) => ({
    uploadAllData: async (ctx) => {
        try {
            const data = await strapi
                .service("api::country.country")
                .uploadAllData(ctx.request.body);
            return ctx.send(data);
        }
        catch (error) {
            console.error("Error uploading country data:", error);
            return ctx.internalServerError("Failed to upload country data");
        }
    },
    deleteAllData: async (ctx) => {
        try {
            const data = await strapi
                .service("api::country.country")
                .deleteAllData();
            return ctx.send(data);
        }
        catch (error) {
            console.error("Error uploading country data:", error);
            return ctx.internalServerError("Failed to upload country data");
        }
    },
}));
