"use strict";
/**
 * country service
 */
Object.defineProperty(exports, "__esModule", { value: true });
const strapi_1 = require("@strapi/strapi");
const dataResponse_dto_1 = require("../../../shared/dto/dataResponse.dto");
exports.default = strapi_1.factories.createCoreService("api::country.country", ({ strapi }) => ({
    async uploadAllData(body) {
        try {
            const countries = body;
            const data = countries.map((item) => {
                return {
                    ...item,
                    publishedAt: new Date(),
                };
            });
            await strapi.db.query("api::country.country").createMany({
                data: data
            });
            return new dataResponse_dto_1.DataResponseDto({
                message: "All countries have been successfully uploaded",
                data: data,
            });
        }
        catch (error) {
            console.log(error);
            return new dataResponse_dto_1.DataResponseDto(null, "Something went wrong in our end please contact system administrator");
        }
    },
    async deleteAllData() {
        try {
            await strapi.db.query("api::country.country").deleteMany({});
            return new dataResponse_dto_1.DataResponseDto("Success", "All countries have been successfully deleted");
        }
        catch (error) {
            console.log(error);
            return new dataResponse_dto_1.DataResponseDto(null, "Something went wrong in our end please contact system administrator");
        }
    }
}));
