"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const moment_1 = __importDefault(require("moment"));
const dataResponse_dto_1 = require("../../../shared/dto/dataResponse.dto");
module.exports = {
    overallStatistics: async () => {
        try {
            const speakers = await strapi.query("api::speaker.speaker").count({
                where: {
                    is_deleted: false,
                    //published:true
                },
            });
            const nonAcceptedCount = await strapi.db
                .query("api::speaker-invitation.speaker-invitation")
                .count({
                where: { is_deleted: false, is_accepted: false },
            });
            const acceptedCount = await strapi.db
                .query("api::speaker-invitation.speaker-invitation")
                .count({
                where: { is_deleted: false, is_accepted: true },
            });
            const agendaSessions = await strapi
                .query("api::agenda-session.agenda-session")
                .count({
                where: {
                    is_deleted: false,
                },
            });
            const agendas = await strapi.query("api::agenda.agenda").count({
                where: {
                    is_deleted: false,
                },
            });
            const updatedSponsors = await strapi.db
                .query("api::sponsor.sponsor")
                .count({
                where: { is_deleted: false, isEdited: true },
            });
            const notUpdatedSponsors = await strapi.db
                .query("api::sponsor.sponsor")
                .count({
                where: { is_deleted: false, isEdited: false },
            });
            const sponsorTickets = await strapi
                .query("api::ticket-master.ticket-master")
                .count({
                where: {
                    is_deleted: false,
                    ticketHolder: "sponsor",
                    status: {
                        $notIn: [
                            "refunded", "cancelled", "deleted", "draft",
                        ],
                    },
                },
            });
            // redeem tickets count
            const redeemTickets = await strapi
                .query("api::ticket-master.ticket-master")
                .count({
                where: {
                    is_deleted: false,
                    ticketHolder: "redeem_link",
                    status: {
                        $notIn: ["refunded", "cancelled", "deleted", "draft"],
                    },
                },
            });
            // adgm tickets count
            const adgmTickets = await strapi
                .query("api::ticket-master.ticket-master")
                .count({
                where: {
                    is_deleted: false,
                    ticketHolder: "adgm",
                    status: {
                        $notIn: [
                            "refunded", "cancelled", "deleted",
                            "draft",
                        ],
                    },
                },
            });
            // executive tickets count
            const executiveTicketsData = {};
            executiveTicketsData["executiveCount"] = await strapi
                .query("api::ticket-master.ticket-master")
                .count({
                where: {
                    is_deleted: false,
                    ticket_id: {
                        id_short: "executive",
                    },
                    status: {
                        $notIn: [
                            "refunded", "cancelled", "deleted",
                            "draft",
                        ],
                    },
                },
                populate: {
                    ticket_id: {
                        select: ["id", "title", "id_short"],
                    },
                },
            });
            // full week tickets count
            const fullWeekTicketsData = {};
            fullWeekTicketsData["fullWeekCount"] = await strapi
                .query("api::ticket-master.ticket-master")
                .count({
                where: {
                    is_deleted: false,
                    ticket_id: {
                        id_short: "delegate",
                    },
                    status: {
                        $notIn: [
                            "refunded", "cancelled", "deleted",
                            "draft",
                        ],
                    },
                },
                populate: {
                    ticket_id: {
                        select: ["id", "title", "id_short"],
                    },
                },
            });
            // general admission tickets count
            const generalAdmissionsData = {};
            generalAdmissionsData["generalAdmissionsCount"] = await strapi
                .query("api::ticket-master.ticket-master")
                .count({
                where: {
                    is_deleted: false,
                    ticket_id: {
                        id_short: "general_admission",
                    },
                    status: {
                        $notIn: [
                            "refunded", "cancelled", "deleted",
                            "draft",
                        ],
                    },
                },
                populate: {
                    ticket_id: {
                        select: ["id", "title", "id_short"],
                    },
                },
            });
            // single day tickets count
            const singleDayData = {};
            singleDayData["singleDayCount"] = await strapi
                .query("api::ticket-master.ticket-master")
                .count({
                where: {
                    is_deleted: false,
                    ticket_id: {
                        id_short: "single_day_delegate",
                    },
                    status: {
                        $notIn: [
                            "refunded", "cancelled", "deleted",
                            "draft",
                        ],
                    },
                },
                populate: {
                    ticket_id: {
                        select: ["id", "title", "id_short"],
                    },
                },
            });
            // ticket types
            const ticketTypes = await strapi.query("api::ticket.ticket").findMany({
                where: {
                    is_deleted: false,
                    status: true,
                },
                select: ["id", "title", "id_short"]
            });
            if (ticketTypes.length > 0) {
                ticketTypes.forEach((ticket) => {
                    if (ticket.id_short === "executive") {
                        executiveTicketsData["ticketData"] = ticket;
                    }
                    else if (ticket.id_short === "delegate") {
                        fullWeekTicketsData["ticketData"] = ticket;
                    }
                    else if (ticket.id_short === "general_admission") {
                        generalAdmissionsData["ticketData"] = ticket;
                    }
                    else if (ticket.id_short === "single_day_delegate") {
                        singleDayData["ticketData"] = ticket;
                    }
                });
            }
            // asset abhu dhabi tickets count
            const assetAbhuDhabiTickets = await strapi
                .query("api::ticket-master.ticket-master")
                .count({
                where: {
                    is_deleted: false,
                    dayShort: "asset_abu_dhabi",
                    status: {
                        $notIn: [
                            "refunded", "cancelled", "deleted",
                            "draft",
                        ],
                    },
                },
            });
            // resolve tickets count
            const resolveTickets = await strapi
                .query("api::ticket-master.ticket-master")
                .count({
                where: {
                    is_deleted: false,
                    dayShort: "resolve",
                    status: {
                        $notIn: [
                            "refunded", "cancelled", "deleted",
                            "draft",
                        ],
                    },
                },
            });
            // fintech abhu dhabi tickets count
            const fintechAbhuDhabiTickets = await strapi
                .query("api::ticket-master.ticket-master")
                .count({
                where: {
                    is_deleted: false,
                    dayShort: "fintech_abu_dhabi",
                    status: {
                        $notIn: [
                            "refunded", "cancelled", "deleted",
                            "draft",
                        ],
                    },
                },
            });
            // adsff tickets count
            const adsffTickets = await strapi
                .query("api::ticket-master.ticket-master")
                .count({
                where: {
                    is_deleted: false,
                    dayShort: "adsff",
                    status: {
                        $notIn: [
                            "refunded", "cancelled", "deleted",
                            "draft",
                        ],
                    },
                },
            });
            // total tickets count
            const totalTickets = await strapi
                .query("api::ticket-master.ticket-master")
                .count({
                where: {
                    is_deleted: false,
                    status: {
                        $notIn: ["refunded", "cancelled", "deleted", "draft"],
                    },
                },
            });
            // total unassigned tickets count
            const unassignedTickets = await strapi
                .query("api::ticket-master.ticket-master")
                .count({
                where: {
                    is_deleted: false,
                    status: "unassigned",
                },
            });
            // total assigned tickets count
            const assignedTickets = await strapi
                .query("api::ticket-master.ticket-master")
                .count({
                where: {
                    is_deleted: false,
                    status: {
                        $in: ["assigned", "reassigned"]
                    },
                },
            });
            // total refunded tickets count
            const refundedTickets = await strapi
                .query("api::ticket-master.ticket-master")
                .count({
                where: {
                    is_deleted: false,
                    status: "refunded",
                },
            });
            // total issued tickets count
            const issuedTickets = await strapi
                .query("api::ticket-master.ticket-master")
                .count({
                where: {
                    is_deleted: false,
                    status: "issued",
                },
            });
            // imported tickets
            const importedTickets = await strapi
                .query("api::ticket-master.ticket-master")
                .count({
                where: {
                    is_deleted: false,
                    ticketHolder: {
                        $in: ["excel", "user"], // excel and users
                    },
                    status: {
                        $notIn: [
                            "refunded", "cancelled", "deleted",
                            "draft",
                        ],
                    },
                },
            });
            // speaker imported tickets
            const speakerImportedTickets = await strapi
                .query("api::ticket-master.ticket-master")
                .count({
                where: {
                    is_deleted: false,
                    ticketHolder: "speaker",
                    status: {
                        $notIn: [
                            "refunded", "cancelled", "deleted",
                            "draft",
                        ],
                    },
                },
            });
            // vvip imported tickets
            const vvipImportedTickets = await strapi
                .query("api::ticket-master.ticket-master")
                .count({
                where: {
                    is_deleted: false,
                    ticketHolder: "vvip",
                    status: {
                        $notIn: [
                            "refunded", "cancelled", "deleted",
                            "draft",
                        ],
                    },
                },
            });
            // discount codes
            const discountCodesCount = await strapi
                .query("api::discount-code.discount-code")
                .count({
                where: {
                    is_deleted: false,
                },
            });
            // total orders count
            const totalOrdersCount = await strapi.query("api::order.order").count({
                where: {
                    is_deleted: false,
                    type: {
                        $in: ["myself", "others"],
                    },
                    status: "Paid",
                    userType: "regular",
                },
            });
            const totalOrders = await strapi.query("api::order.order").findMany({
                where: {
                    is_deleted: false,
                    type: {
                        $in: ["myself", "others"],
                    },
                    status: {
                        $notIn: ["Refunded", "Cancelled", "Deleted"],
                    },
                    userType: "regular",
                },
                select: ["totalAmount", "ticketCount"],
            });
            const totalSalesAmount = totalOrders.reduce((sum, order) => sum + (order.totalAmount || 0), 0);
            // failed payments
            const failedPayments = await strapi
                .query("api::payment-log.payment-log")
                .count({
                where: {
                    status: {
                        $in: [
                            //"rejected", "cancelled",
                            "pending",
                        ],
                    },
                },
            });
            // redeem links
            const redeemLinks = await strapi
                .query("api::redeem-link.redeem-link")
                .count({
                where: {
                    is_deleted: false,
                },
            });
            // paid tickets
            const paidTickets = totalOrders.reduce((sum, order) => {
                return sum + order.ticketCount;
            }, 0);
            // ------------Badge Categories----------------
            // official - Badge
            const officialBadgeCount = await strapi
                .query("api::ticket-master.ticket-master")
                .count({
                where: {
                    is_deleted: false,
                    badgeCategory: "Official",
                    status: {
                        $notIn: [
                            "refunded", "cancelled", "deleted",
                            "draft",
                        ],
                    },
                },
            });
            // full week - Badge
            const fullWeekBadgeCount = await strapi
                .query("api::ticket-master.ticket-master")
                .count({
                where: {
                    is_deleted: false,
                    badgeCategory: "Full Week",
                    status: {
                        $notIn: [
                            "refunded", "cancelled", "deleted",
                            "draft",
                        ],
                    },
                },
            });
            // Asset Abu Dhabi - Badge
            const assetBadgeCount = await strapi
                .query("api::ticket-master.ticket-master")
                .count({
                where: {
                    is_deleted: false,
                    badgeCategory: "Asset Abu Dhabi",
                    status: {
                        $notIn: [
                            "refunded", "cancelled", "deleted",
                            "draft",
                        ],
                    },
                },
            });
            // Resolve - Badge
            const resolveBadgeCount = await strapi
                .query("api::ticket-master.ticket-master")
                .count({
                where: {
                    is_deleted: false,
                    badgeCategory: "RESOLVE",
                    status: {
                        $notIn: [
                            "refunded", "cancelled", "deleted",
                            "draft",
                        ],
                    },
                },
            });
            //Fintech Abu Dhabi - Badge
            const fintechBadgeCount = await strapi
                .query("api::ticket-master.ticket-master")
                .count({
                where: {
                    is_deleted: false,
                    badgeCategory: "Fintech Abu Dhabi",
                    status: {
                        $notIn: [
                            "refunded", "cancelled", "deleted",
                            "draft",
                        ],
                    },
                },
            });
            // ADSFF -Badge
            const adsffBadgeCount = await strapi
                .query("api::ticket-master.ticket-master")
                .count({
                where: {
                    is_deleted: false,
                    badgeCategory: "ADSFF",
                    status: {
                        $notIn: [
                            "refunded", "cancelled", "deleted",
                            "draft",
                        ],
                    },
                },
            });
            // Visitor - Badge
            const visitorBadgeCount = await strapi
                .query("api::ticket-master.ticket-master")
                .count({
                where: {
                    is_deleted: false,
                    badgeCategory: "Visitor",
                    status: {
                        $notIn: [
                            "refunded", "cancelled", "deleted",
                            "draft",
                        ],
                    },
                },
            });
            // Speakers - Badge
            const speakersBadgeCount = await strapi
                .query("api::ticket-master.ticket-master")
                .count({
                where: {
                    is_deleted: false,
                    badgeCategory: "Speaker",
                    status: {
                        $notIn: [
                            "refunded", "cancelled", "deleted",
                            "draft",
                        ],
                    },
                },
            });
            // Partner - Badge
            const partnerBadgeCount = await strapi
                .query("api::ticket-master.ticket-master")
                .count({
                where: {
                    is_deleted: false,
                    badgeCategory: "Partner",
                    status: {
                        $notIn: [
                            "refunded", "cancelled", "deleted",
                            "draft",
                        ],
                    },
                },
            });
            // Guest - Badge
            const guestBadgeCount = await strapi
                .query("api::ticket-master.ticket-master")
                .count({
                where: {
                    is_deleted: false,
                    badgeCategory: "Guest",
                    status: {
                        $notIn: [
                            "refunded", "cancelled", "deleted",
                            "draft",
                        ],
                    },
                },
            });
            // Media - Badge
            const mediaBadgeCount = await strapi
                .query("api::ticket-master.ticket-master")
                .count({
                where: {
                    is_deleted: false,
                    badgeCategory: "Media",
                    status: {
                        $notIn: [
                            "refunded", "cancelled", "deleted",
                            "draft",
                        ],
                    },
                },
            });
            // ADGM - Badge
            const adgmBadgeCount = await strapi
                .query("api::ticket-master.ticket-master")
                .count({
                where: {
                    is_deleted: false,
                    badgeCategory: "ADGM",
                    status: {
                        $notIn: [
                            "refunded", "cancelled", "deleted",
                            "draft",
                        ],
                    },
                },
            });
            // ADGM Organiser 
            const adgmOrganiserBadgeCount = await strapi
                .query("api::ticket-master.ticket-master")
                .count({
                where: {
                    is_deleted: false,
                    badgeCategory: "ADGM Organiser",
                    status: {
                        $notIn: [
                            "refunded", "cancelled", "deleted",
                            "draft",
                        ],
                    },
                },
            });
            // ADGM Protocol
            const adgmProtocolBadgeCount = await strapi
                .query("api::ticket-master.ticket-master")
                .count({
                where: {
                    is_deleted: false,
                    badgeCategory: "ADGM Protocol",
                    status: {
                        $notIn: ["refunded", "cancelled", "deleted", "draft"],
                    },
                },
            });
            // Startup
            const startupBadgeCount = await strapi
                .query("api::ticket-master.ticket-master")
                .count({
                where: {
                    is_deleted: false,
                    badgeCategory: "Startup",
                    status: {
                        $notIn: ["refunded", "cancelled", "deleted", "draft"],
                    },
                },
            });
            // Organiser
            const organiserBadgeCount = await strapi
                .query("api::ticket-master.ticket-master")
                .count({
                where: {
                    is_deleted: false,
                    badgeCategory: "Organiser",
                    status: {
                        $notIn: ["refunded", "cancelled", "deleted", "draft"],
                    },
                },
            });
            // ADGM Executives
            const adgmExecutiveBadgeCount = await strapi
                .query("api::ticket-master.ticket-master")
                .count({
                where: {
                    is_deleted: false,
                    badgeCategory: "ADGM Executive",
                    status: {
                        $notIn: ["refunded", "cancelled", "deleted", "draft"],
                    },
                },
            });
            // Photographer
            const adfwOfficialPhotographerBadgeCount = await strapi
                .query("api::ticket-master.ticket-master")
                .count({
                where: {
                    is_deleted: false,
                    badgeCategory: "Photographer",
                    status: {
                        $notIn: ["refunded", "cancelled", "deleted", "draft"],
                    },
                },
            });
            // Videographer
            const adfwOfficialVideographerBadgeCount = await strapi
                .query("api::ticket-master.ticket-master")
                .count({
                where: {
                    is_deleted: false,
                    badgeCategory: "Videographer",
                    status: {
                        $notIn: ["refunded", "cancelled", "deleted", "draft"],
                    },
                },
            });
            // Crew
            const crewBadgeCount = await strapi
                .query("api::ticket-master.ticket-master")
                .count({
                where: {
                    is_deleted: false,
                    badgeCategory: "Crew",
                    status: {
                        $notIn: ["refunded", "cancelled", "deleted", "draft"],
                    },
                },
            });
            // Entertainment Artist
            const entertainmentArtistBadgeCount = await strapi
                .query("api::ticket-master.ticket-master")
                .count({
                where: {
                    is_deleted: false,
                    badgeCategory: "Entertainment Artist",
                    status: {
                        $notIn: ["refunded", "cancelled", "deleted", "draft"],
                    },
                },
            });
            // Official Executive Invited Guest
            const officialExecutiveInvitedGuestBadgeCount = await strapi
                .query("api::ticket-master.ticket-master")
                .count({
                where: {
                    is_deleted: false,
                    badgeCategory: "Official Executive Invited Guest",
                    status: {
                        $notIn: ["refunded", "cancelled", "deleted", "draft"],
                    },
                },
            });
            // Protocol
            const protocolBadgeCount = await strapi
                .query("api::ticket-master.ticket-master")
                .count({
                where: {
                    is_deleted: false,
                    badgeCategory: "Protocol",
                    status: {
                        $notIn: ["refunded", "cancelled", "deleted", "draft"],
                    },
                },
            });
            // Security
            const securityBadgeCount = await strapi
                .query("api::ticket-master.ticket-master")
                .count({
                where: {
                    is_deleted: false,
                    badgeCategory: "Security",
                    status: {
                        $notIn: ["refunded", "cancelled", "deleted", "draft"],
                    },
                },
            });
            // Support Staff
            const supportStaffBadgeCount = await strapi
                .query("api::ticket-master.ticket-master")
                .count({
                where: {
                    is_deleted: false,
                    badgeCategory: "Support Staff",
                    status: {
                        $notIn: ["refunded", "cancelled", "deleted", "draft"],
                    },
                },
            });
            // -------- onsite registrations ----------
            const onsiteTickets = await strapi
                .query("api::ticket-master.ticket-master")
                .count({
                where: {
                    is_deleted: false,
                    ticketHolder: "onsite",
                    status: {
                        $notIn: ["refunded", "cancelled", "deleted", "draft"],
                    },
                },
            });
            // ----- bar graph data ------
            const graphData = await strapi.service("api::dashboard.dashboard").graphData();
            // ------- pie chart data -------
            // issued executive tickets count
            const issuedExecutiveCount = await strapi
                .query("api::ticket-master.ticket-master")
                .count({
                where: {
                    is_deleted: false,
                    ticket_id: {
                        id_short: "executive",
                    },
                    status: "issued",
                }
            });
            // issued full week tickets count
            const issuedFullWeekCount = await strapi
                .query("api::ticket-master.ticket-master")
                .count({
                where: {
                    is_deleted: false,
                    ticket_id: {
                        id_short: "delegate",
                    },
                    status: "issued",
                }
            });
            // issued general admission tickets count
            const issuedGeneralAdmissionsCount = await strapi
                .query("api::ticket-master.ticket-master")
                .count({
                where: {
                    is_deleted: false,
                    ticket_id: {
                        id_short: "general_admission",
                    },
                    status: "issued",
                }
            });
            // issued single day tickets count
            const issuedSingleDayCount = await strapi
                .query("api::ticket-master.ticket-master")
                .count({
                where: {
                    is_deleted: false,
                    ticket_id: {
                        id_short: "single_day_delegate",
                    },
                    status: "issued",
                }
            });
            // asset abhu dhabi tickets count
            const issuedAssetAbhuDhabiTickets = await strapi
                .query("api::ticket-master.ticket-master")
                .count({
                where: {
                    is_deleted: false,
                    dayShort: "asset_abu_dhabi",
                    status: "issued",
                },
            });
            // resolve tickets count
            const issuedResolveTickets = await strapi
                .query("api::ticket-master.ticket-master")
                .count({
                where: {
                    is_deleted: false,
                    dayShort: "resolve",
                    status: "issued"
                },
            });
            // fintech abhu dhabi tickets count
            const issuedFintechAbhuDhabiTickets = await strapi
                .query("api::ticket-master.ticket-master")
                .count({
                where: {
                    is_deleted: false,
                    dayShort: "fintech_abu_dhabi",
                    status: "issued"
                },
            });
            // adsff tickets count
            const issuedAdsffTickets = await strapi
                .query("api::ticket-master.ticket-master")
                .count({
                where: {
                    is_deleted: false,
                    dayShort: "adsff",
                    status: "issued"
                },
            });
            // ------ evento entries -------
            // total assigned tickets without evento entry
            const assignedTicketsWithoutEventoRegistry = await strapi
                .query("api::ticket-master.ticket-master")
                .count({
                where: {
                    is_deleted: false,
                    status: {
                        $in: ["assigned", "reassigned"]
                    },
                    isSyncEvento: false
                },
            });
            const data = {
                speakers,
                speakerInvitations: {
                    acceptedCount,
                    nonAcceptedCount,
                    total: Number(nonAcceptedCount) + Number(acceptedCount),
                },
                agendaSessions,
                agendas,
                sponsors: {
                    updatedSponsors,
                    notUpdatedSponsors,
                    total: Number(updatedSponsors) + Number(notUpdatedSponsors),
                },
                ticketsData: {
                    totalTickets,
                    paidTickets,
                    sponsorTickets,
                    redeemTickets,
                    adgmTickets,
                    importedTickets,
                    speakerImportedTickets,
                    vvipImportedTickets,
                    unassignedTickets,
                    assignedTickets,
                    issuedTickets,
                    refundedTickets,
                    executiveTicketsData,
                    fullWeekTicketsData,
                    generalAdmissionsData,
                    singleDayData,
                    assetAbhuDhabiTickets,
                    resolveTickets,
                    fintechAbhuDhabiTickets,
                    adsffTickets,
                    onsiteTickets,
                    assignedTicketsWithoutEventoRegistry
                },
                badgeCategories: {
                    officialBadgeCount,
                    fullWeekBadgeCount,
                    assetBadgeCount,
                    resolveBadgeCount,
                    fintechBadgeCount,
                    adsffBadgeCount,
                    visitorBadgeCount,
                    speakersBadgeCount,
                    partnerBadgeCount,
                    guestBadgeCount,
                    mediaBadgeCount,
                    adgmBadgeCount,
                    adgmOrganiserBadgeCount,
                    adgmProtocolBadgeCount,
                    startupBadgeCount,
                    organiserBadgeCount,
                    adgmExecutiveBadgeCount,
                    adfwOfficialPhotographerBadgeCount,
                    adfwOfficialVideographerBadgeCount,
                    crewBadgeCount,
                    entertainmentArtistBadgeCount,
                    officialExecutiveInvitedGuestBadgeCount,
                    protocolBadgeCount,
                    securityBadgeCount,
                    supportStaffBadgeCount
                },
                discountCodes: discountCodesCount,
                orders: totalOrdersCount,
                totalSalesAmount,
                failedPayments,
                ticketTypes: ticketTypes === null || ticketTypes === void 0 ? void 0 : ticketTypes.length,
                redeemLinks,
                graphData,
                pieChartData: {
                    issuedExecutiveCount,
                    issuedFullWeekCount,
                    issuedGeneralAdmissionsCount,
                    issuedSingleDayCount,
                    issuedAssetAbhuDhabiTickets,
                    issuedResolveTickets,
                    issuedFintechAbhuDhabiTickets,
                    issuedAdsffTickets,
                }
            };
            return new dataResponse_dto_1.DataResponseDto(data, "Data fetched successfully");
        }
        catch (error) {
            console.log(error);
            return new dataResponse_dto_1.DataResponseDto(null, "Something went wrong in our end please contact system administrator");
        }
    },
    graphData: async () => {
        try {
            // Get date range for last two weeks
            const today = (0, moment_1.default)().endOf('day');
            const twoWeeksAgo = (0, moment_1.default)().subtract(13, 'days').startOf('day');
            // Create array of all dates in the range
            const dateRange = [];
            let currentDate = twoWeeksAgo.clone();
            while (currentDate <= today) {
                dateRange.push(currentDate.clone());
                currentDate.add(1, 'days');
            }
            // Get tickets count for each date
            const ticketsByDate = await Promise.all(dateRange.map(async (date) => {
                const startOfDay = date.startOf('day').toISOString();
                const endOfDay = date.endOf('day').toISOString();
                const count = await strapi
                    .query("api::ticket-master.ticket-master")
                    .count({
                    where: {
                        is_deleted: false,
                        status: "issued",
                        createdAt: {
                            $gte: startOfDay,
                            $lte: endOfDay
                        }
                    },
                });
                return {
                    date: date.format('YYYY-MM-DD'),
                    count: count
                };
            }));
            return ticketsByDate;
        }
        catch (error) {
            console.log(error);
            return new dataResponse_dto_1.DataResponseDto(null, "Something went wrong in our end please contact system administrator");
        }
    },
    async appReport() {
        try {
            const appUsers = await strapi.db
                .query("api::ticket-master.ticket-master")
                .findMany({
                where: {
                    is_deleted: false,
                    status: "issued",
                    ticket_id: {
                        $ne: 4
                    },
                    app_session_logs: {
                        $notNull: true
                    }
                },
                orderBy: { createdAt: "desc" },
                populate: {
                    ticket_id: true,
                    interests: true,
                    favourites: true
                },
            });
            const appChatUsers = await strapi.db
                .query("api::ticket-master.ticket-master")
                .findMany({
                where: {
                    is_deleted: false,
                    status: "issued",
                    allowChat: true,
                    ticket_id: {
                        $ne: 4
                    }
                },
                orderBy: { createdAt: "desc" }
            });
            const promotionAgreedUsers = await strapi.db
                .query("api::ticket-master.ticket-master")
                .findMany({
                where: {
                    is_deleted: false,
                    status: "issued",
                    isTermsAgreed: true,
                    ticket_id: {
                        $ne: 4
                    }
                },
                orderBy: { createdAt: "desc" }
            });
            const activeAppSessions = await strapi.db
                .query("api::app-session-log.app-session-log")
                .findMany({
                where: {
                    is_active: true
                },
                populate: {
                    ticket_id: true
                }
            });
            const activeUsers = activeAppSessions
                .flatMap((item) => item.ticket_id)
                .filter((item) => item !== null);
            const uniqueActiveUsers = [
                ...new Map(activeUsers.map((item) => [item.id, item])).values(),
            ];
            const logData = await strapi.service("api::dashboard.dashboard").getLoginCountsByDateAndHour();
            let response = {
                logData,
                appUsers,
                activeAppSessions: {
                    totalActiveAppSessions: activeAppSessions.length,
                    activeUsers: uniqueActiveUsers
                },
                openToNetworkData: {
                    totalCount: appChatUsers.length,
                    chatUsers: appChatUsers
                },
                promotionAgreedUserData: {
                    totalCount: promotionAgreedUsers.length,
                    promotionAgreedUsers
                }
            };
            return new dataResponse_dto_1.DataResponseDto(response, "Report fetched successfully");
        }
        catch (error) {
            console.log(error);
            return new dataResponse_dto_1.DataResponseDto(null, "Something went wrong in our end please contact system administrator");
        }
    },
    getLoginCountsByDateAndHour: async () => {
        const startDate = new Date('2023-11-21');
        startDate.setHours(0, 0, 0, 0);
        const endDate = new Date(); // Current date
        endDate.setHours(23, 59, 59, 999);
        const sessions = await strapi.db.query("api::app-session-log.app-session-log").findMany({
            where: {
                login_time: {
                    $gte: startDate,
                    $lte: endDate
                }
            },
            select: ['login_time']
        });
        // Create an object to store counts by date and hour
        const countsByDateAndHour = {};
        sessions.forEach(session => {
            const loginDate = new Date(session.login_time);
            const dateStr = loginDate.toISOString().split('T')[0]; // YYYY-MM-DD
            const hour = loginDate.getHours();
            // Initialize date object if it doesn't exist
            if (!countsByDateAndHour[dateStr]) {
                countsByDateAndHour[dateStr] = Array.from({ length: 24 }, (_, i) => ({
                    hour: i,
                    hour_display: `${String(i).padStart(2, '0')}:00`,
                    count: 0
                }));
            }
            // Increment count for this hour
            countsByDateAndHour[dateStr][hour].count++;
        });
        function findPeakHour(sessions) {
            const hourCounts = Array(24).fill(0);
            sessions.forEach(session => {
                const hour = new Date(session.login_time).getHours();
                hourCounts[hour]++;
            });
            const maxCount = Math.max(...hourCounts);
            const peakHour = hourCounts.indexOf(maxCount);
            return {
                hour: peakHour,
                hour_display: `${String(peakHour).padStart(2, '0')}:00`,
                count: maxCount
            };
        }
        // Convert to array format with dates
        const result = Object.entries(countsByDateAndHour).map(([date, hours]) => ({
            date,
            total_count: hours === null || hours === void 0 ? void 0 : hours.reduce((sum, hour) => sum + hour.count, 0),
            hourly_counts: hours
        }));
        // Sort by date
        result.sort((a, b) => new Date(a.date).getTime() - new Date(b.date).getTime());
        // Add summary statistics
        const summary = {
            total_logins: sessions.length,
            date_range: {
                from: startDate.toISOString().split('T')[0],
                to: endDate.toISOString().split('T')[0]
            },
            peak_hour: findPeakHour(sessions),
            daily_average: Math.round(sessions.length / result.length)
        };
        return {
            summary,
            daily_data: result
        };
    }
};
