"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const strapi_1 = require("@strapi/strapi");
exports.default = strapi_1.factories.createCoreController("api::discount-code.discount-code", ({ strapi }) => ({
    findAllCodes: async (ctx) => {
        try {
            const data = await strapi
                .service("api::discount-code.discount-code")
                .findAllCodes(ctx.request.query);
            return ctx.send(data);
        }
        catch (error) {
            console.log(error);
        }
    },
    createDiscountCode: async (ctx) => {
        try {
            const data = await strapi
                .service("api::discount-code.discount-code")
                .createDiscountCode(ctx.request.body);
            return ctx.send(data);
        }
        catch (error) {
            console.log(error);
        }
    },
    updateDiscountCode: async (ctx) => {
        try {
            const { id } = ctx.params;
            if (!id) {
                return ctx.badRequest("ID is required");
            }
            const data = await strapi
                .service("api::discount-code.discount-code")
                .updateDiscountCode(id, ctx.request.body);
            return ctx.send(data);
        }
        catch (error) {
            console.log(error);
        }
    },
    findExportData: async (ctx) => {
        try {
            const data = await strapi.service("api::discount-code.discount-code").findExportData();
            return ctx.send(data);
        }
        catch (error) {
            console.log(error);
        }
    },
    checkCodeExists: async (ctx) => {
        try {
            const data = await strapi
                .service("api::discount-code.discount-code")
                .checkExists(ctx.request.query);
            return ctx.send(data);
        }
        catch (error) {
            console.log(error);
        }
    },
    softDelete: async (ctx) => {
        try {
            const { id } = ctx.params;
            if (!id) {
                return ctx.badRequest("ID is required");
            }
            const data = await strapi
                .service("api::discount-code.discount-code")
                .softDelete(id);
            return ctx.send(data);
        }
        catch (error) {
            console.log(error);
        }
    },
}));
