"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const strapi_1 = require("@strapi/strapi");
const dataResponse_dto_1 = require("../../../shared/dto/dataResponse.dto");
exports.default = strapi_1.factories.createCoreService("api::discount-code.discount-code", ({ strapi }) => ({
    async createDiscountCode(body) {
        try {
            const uniqueCode = await strapi.db.query("api::discount-code.discount-code").findMany({
                where: {
                    code: body === null || body === void 0 ? void 0 : body.code.trim(),
                    is_deleted: false,
                },
            });
            if (uniqueCode.length) {
                return new dataResponse_dto_1.DataResponseDto(null, "Discount code already exists");
            }
            const data = await strapi.db.query("api::discount-code.discount-code").create({
                data: {
                    code: body === null || body === void 0 ? void 0 : body.code,
                    discount: body === null || body === void 0 ? void 0 : body.discount,
                    count: body === null || body === void 0 ? void 0 : body.count,
                    isExpired: body === null || body === void 0 ? void 0 : body.isExpired,
                    status: body === null || body === void 0 ? void 0 : body.isExpired,
                    discount_type: body === null || body === void 0 ? void 0 : body.discount_type,
                    ticket_type: body === null || body === void 0 ? void 0 : body.ticket_type,
                    remaining_count: body === null || body === void 0 ? void 0 : body.count,
                    creator: body === null || body === void 0 ? void 0 : body.creator
                },
                populate: true
            });
            return new dataResponse_dto_1.DataResponseDto(data, "discount-code created successfully");
        }
        catch (error) {
            console.log(error);
            return new dataResponse_dto_1.DataResponseDto(null, "Something went wrong in our end please contact system administrator");
        }
    },
    async updateDiscountCode(id, body) {
        try {
            const discountCode = await strapi.db
                .query("api::discount-code.discount-code")
                .findOne({
                where: { id, is_deleted: false }
            });
            if (!discountCode) {
                return new dataResponse_dto_1.DataResponseDto(null);
            }
            const uniqueCode = await strapi.db.query("api::discount-code.discount-code").findMany({
                where: {
                    code: body === null || body === void 0 ? void 0 : body.code.trim(),
                    is_deleted: false,
                    id: {
                        $ne: id
                    }
                },
            });
            if (uniqueCode.length) {
                return new dataResponse_dto_1.DataResponseDto(null, "Redeem link with same title already exists");
            }
            const remaining = Number(discountCode === null || discountCode === void 0 ? void 0 : discountCode.remaining_count) +
                (Number(body === null || body === void 0 ? void 0 : body.count) - Number(discountCode === null || discountCode === void 0 ? void 0 : discountCode.count));
            const data = await strapi.db
                .query("api::discount-code.discount-code")
                .update({
                where: { id, is_deleted: false },
                data: {
                    code: body === null || body === void 0 ? void 0 : body.code,
                    discount: body === null || body === void 0 ? void 0 : body.discount,
                    count: body === null || body === void 0 ? void 0 : body.count,
                    isExpired: body === null || body === void 0 ? void 0 : body.isExpired,
                    status: body === null || body === void 0 ? void 0 : body.isExpired,
                    discount_type: body === null || body === void 0 ? void 0 : body.discount_type,
                    ticket_type: body === null || body === void 0 ? void 0 : body.ticket_type,
                    remaining_count: Number(remaining),
                    modifiedBy: body === null || body === void 0 ? void 0 : body.modifiedBy
                },
            });
            return new dataResponse_dto_1.DataResponseDto(data, "discount code updated successfully");
        }
        catch (error) {
            console.log(error);
            return new dataResponse_dto_1.DataResponseDto(null, "Something went wrong in our end please contact system administrator");
        }
    },
    async findExportData() {
        try {
            const data = await strapi.db.query("api::discount-code.discount-code").findMany({
                where: { is_deleted: false },
                orderBy: { id: "desc" },
            });
            return new dataResponse_dto_1.DataResponseDto(data, "discount-code data fetched successfully");
        }
        catch (error) {
            console.log(error);
            return new dataResponse_dto_1.DataResponseDto(null, "Something went wrong in our end please contact system administrator");
        }
    },
    async findAllCodes(params) {
        try {
            const { page, pageSize, search, filters } = params;
            let limit = Number(pageSize) || 10;
            let pageNumber = Number(page) || 1;
            const offset = (Number(pageNumber) - 1) * Number(limit);
            const where = {
                is_deleted: false,
                ...(filters && Object.keys(filters).length > 0 && { ...filters }),
                ...(search &&
                    search.trim() && {
                    $or: [
                        { code: { $containsi: search } },
                        { discount: { $containsi: search } }
                    ],
                }),
            };
            const data = await strapi.db.query("api::discount-code.discount-code").findMany({
                where,
                offset,
                limit: limit,
                orderBy: { id: "desc" },
                populate: {
                    creator: {
                        select: ["username", "firstName", "lastName"]
                    },
                    modifiedBy: {
                        select: ["username", "firstName", "lastName"]
                    }
                }
            });
            if (data) {
                const totalDataCount = await strapi
                    .query("api::discount-code.discount-code")
                    .count({ where });
                const pageCount = Math.ceil(totalDataCount / limit);
                return new dataResponse_dto_1.DataResponseDto({
                    data,
                    pagination: {
                        page: Number(pageNumber),
                        pageSize: Number(limit),
                        pageCount,
                        total: Number(totalDataCount),
                    },
                }, "discount-code data fetched successfully");
            }
            else {
                return new dataResponse_dto_1.DataResponseDto(null);
            }
        }
        catch (error) {
            console.log("error", error);
        }
    },
    async checkExists(body) {
        try {
            const { code, ticket_type } = body;
            const discountCode = await strapi.db
                .query("api::discount-code.discount-code")
                .findOne({
                where: { code, is_deleted: false },
            });
            if (!discountCode ||
                Number(discountCode.remaining_count) === 0 ||
                (discountCode.ticket_type !== "all" &&
                    discountCode.ticket_type !== ticket_type)) {
                return new dataResponse_dto_1.DataResponseDto(null, "Please provide valid discount code");
            }
            if (discountCode.isExpired) {
                return new dataResponse_dto_1.DataResponseDto(null, "This discount code has expired. Please try a different one");
            }
            return new dataResponse_dto_1.DataResponseDto(discountCode, "discount code is valid");
        }
        catch (error) {
            console.log(error);
            return new dataResponse_dto_1.DataResponseDto(null, "Something went wrong in our end please contact system administrator");
        }
    },
    async softDelete(id) {
        try {
            const data = await strapi.db
                .query("api::discount-code.discount-code")
                .update({
                where: { id, is_deleted: false },
                data: {
                    is_deleted: true,
                },
            });
            if (data) {
                return new dataResponse_dto_1.DataResponseDto(data, "Discount code deleted successfully");
            }
            else {
                return new dataResponse_dto_1.DataResponseDto(null);
            }
        }
        catch (error) {
            console.log(error);
            return new dataResponse_dto_1.DataResponseDto(null, "Something went wrong in our end please contact system administrator");
        }
    },
    async updateDiscountCodeCount(id) {
        try {
            const discountCode = await strapi.db
                .query("api::discount-code.discount-code")
                .findOne({
                where: { id, is_deleted: false },
            });
            if (!discountCode) {
                return new dataResponse_dto_1.DataResponseDto(null, "Discount code not found");
            }
            if (Number(discountCode.remaining_count) <= 0) {
                return new dataResponse_dto_1.DataResponseDto(null, "Discount code count is zero");
            }
            const newCount = Number(discountCode.remaining_count) - 1;
            const data = await strapi.db
                .query("api::discount-code.discount-code")
                .update({
                where: { id },
                data: {
                    remaining_count: newCount,
                    status: newCount > 0,
                    isExpired: newCount < 0,
                },
            });
            if (data) {
                return new dataResponse_dto_1.DataResponseDto(data, "Discount code count updated successfully");
            }
            else {
                return new dataResponse_dto_1.DataResponseDto(null);
            }
        }
        catch (error) {
            console.log(error);
            return new dataResponse_dto_1.DataResponseDto(null, "Something went wrong in our end please contact system administrator");
        }
    },
}));
