"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const strapi_1 = require("@strapi/strapi");
exports.default = strapi_1.factories.createCoreController("api::entertainment.entertainment", ({ strapi }) => ({
    findAllData: async (ctx) => {
        try {
            const data = await strapi
                .service("api::entertainment.entertainment")
                .findAllData(ctx.request.query);
            return ctx.send(data);
        }
        catch (error) {
            console.log(error);
        }
    },
    softDelete: async (ctx) => {
        try {
            const { id } = ctx.params;
            if (!id) {
                return ctx.badRequest("ID is required");
            }
            const data = await strapi
                .service("api::entertainment.entertainment")
                .softDelete(id);
            return ctx.send(data);
        }
        catch (error) {
            console.log(error);
        }
    },
}));
