"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const strapi_1 = require("@strapi/strapi");
exports.default = strapi_1.factories.createCoreController("api::favourite.favourite", ({ strapi }) => ({
    addToFavourites: async (ctx) => {
        try {
            const { ticketId, sessionId, agendaId, agendaDate } = ctx.request.body;
            if (!ticketId || !sessionId) {
                return ctx.badRequest("ID is required");
            }
            const data = await strapi.service("api::favourite.favourite").addToFavourites(ticketId, sessionId, agendaId, agendaDate);
            return ctx.send(data);
        }
        catch (error) {
            console.log(error);
        }
    },
    removeFromFavourites: async (ctx) => {
        try {
            const { ticketId, sessionId } = ctx.params;
            if (!ticketId || !sessionId) {
                return ctx.badRequest("ID is required");
            }
            const data = await strapi.service("api::favourite.favourite").removeFromFavourites(ticketId, sessionId);
            return ctx.send(data);
        }
        catch (error) {
            console.log(error);
        }
    },
    softDelete: async (ctx) => {
        try {
            const { id } = ctx.params;
            if (!id) {
                return ctx.badRequest("ID is required");
            }
            const data = await strapi.service("api::favourite.favourite").softDelete(id);
            return ctx.send(data);
        }
        catch (error) {
            console.log(error);
        }
    },
    removeAllFavourites: async (ctx) => {
        try {
            const { id } = ctx.params;
            if (!id) {
                return ctx.badRequest("ID is required");
            }
            const data = await strapi.service("api::favourite.favourite").removeAllFavourites(id);
            return ctx.send(data);
        }
        catch (error) {
            console.log(error);
        }
    },
    findFavouritesByUser: async (ctx) => {
        try {
            const { id } = ctx.params;
            if (!id) {
                return ctx.badRequest("ID is required");
            }
            const data = await strapi.service("api::favourite.favourite").findFavouritesByUser(id, ctx.request.query);
            return ctx.send(data);
        }
        catch (error) {
            console.log(error);
        }
    },
    findFavouritesByTicketId: async (ctx) => {
        try {
            const { id } = ctx.params;
            if (!id) {
                return ctx.badRequest("ID is required");
            }
            const data = await strapi.service("api::favourite.favourite").findFavouritesByTicketId(id, ctx.request.query);
            return ctx.send(data);
        }
        catch (error) {
            console.log(error);
        }
    },
}));
