"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const strapi_1 = require("@strapi/strapi");
const defaultRouter = strapi_1.factories.createCoreRouter('api::favourite.favourite');
const customRouter = (innerRouter, extraRoutes = []) => {
    let routes;
    return {
        get prefix() {
            return innerRouter.prefix;
        },
        get routes() {
            if (!routes)
                routes = innerRouter.routes.concat(extraRoutes);
            return routes;
        },
    };
};
const extraRoutes = [
    {
        method: "POST",
        path: "/favourites/add",
        handler: "favourite.addToFavourites",
        config: {
            auth: false,
            policies: [],
            middlewares: [],
        },
    },
    {
        method: "DELETE",
        path: "/favourites/remove/:ticketId/:sessionId",
        handler: "favourite.removeFromFavourites",
        config: {
            auth: false,
            policies: [],
            middlewares: [],
        },
    },
    {
        method: "GET",
        path: "/favourites/delete/:id",
        handler: "favourite.softDelete",
        config: {
            auth: false,
            policies: [],
            middlewares: [],
        },
    },
    {
        method: "GET",
        path: "/favourites/findByUser/:id",
        handler: "favourite.findFavouritesByUser",
        config: {
            auth: false,
            policies: [],
            middlewares: [],
        },
    },
    {
        method: "GET",
        path: "/favourites/findByTicketId/:id",
        handler: "favourite.findFavouritesByTicketId",
        config: {
            auth: false,
            policies: [],
            middlewares: [],
        },
    },
    {
        method: "DELETE",
        path: "/favourites/clear-data/:id",
        handler: "favourite.removeAllFavourites",
        config: {
            auth: false,
            policies: [],
            middlewares: [],
        },
    },
];
exports.default = customRouter(defaultRouter, extraRoutes);
