module.exports = {
    async uploadImage(ctx, next) {
        try {
            if (!ctx.request.files) {
                return ctx.send({
                    status: false,
                    message: "No file uploaded",
                });
            }
            const data = await strapi
                .service("api::image-compress.image-compress")
                .uploadImage(ctx.request.files);
            return ctx.send(data);
        }
        catch (error) {
            console.log(error);
            return error;
        }
    },
    async uploadImageorPdf(ctx, next) {
        try {
            const { isCompress } = ctx.request.query;
            if (!ctx.request.files) {
                return ctx.send({
                    status: false,
                    message: "No file uploaded",
                });
            }
            const data = await strapi
                .service("api::image-compress.image-compress")
                .uploadImageorPdf(ctx.request.files, isCompress);
            return ctx.send(data);
        }
        catch (error) {
            console.log(error);
            return error;
        }
    },
    async deleteImage(ctx, next) {
        try {
            const data = await strapi
                .service("api::image-compress.image-compress")
                .deleteImage(ctx.request.query);
            return ctx.send(data);
        }
        catch (error) {
            console.log(error);
            return error;
        }
    },
    async uploadImageToAzure(ctx, next) {
        try {
            if (!ctx.request.files) {
                return ctx.send({
                    status: false,
                    message: "No file uploaded",
                });
            }
            const data = await strapi
                .service("api::image-compress.image-compress")
                .uploadImageToAzure(ctx.request.files); // 👈 FIXED HERE
            return ctx.send(data);
        }
        catch (error) {
            console.log(error);
            return error;
        }
    },
};
