"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const strapi_1 = require("@strapi/strapi");
exports.default = strapi_1.factories.createCoreController("api::interest.interest", ({ strapi }) => ({
    softDelete: async (ctx) => {
        try {
            const { id } = ctx.params;
            if (!id) {
                return ctx.badRequest("ID is required");
            }
            const data = await strapi
                .service("api::interest.interest")
                .softDelete(id);
            return ctx.send(data);
        }
        catch (error) {
            console.log(error);
        }
    },
    createInterest: async (ctx) => {
        try {
            const data = await strapi
                .service("api::interest.interest")
                .createInterest(ctx.request.body);
            return ctx.send(data);
        }
        catch (error) {
            console.log(error);
        }
    },
    findInterestsByTicketId: async (ctx) => {
        try {
            const { id } = ctx.params;
            if (!id) {
                return ctx.badRequest("ID is required");
            }
            const data = await strapi
                .service("api::interest.interest")
                .findInterestsByTicketId(id);
            return ctx.send(data);
        }
        catch (error) {
            console.log(error);
        }
    },
}));
