"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const strapi_1 = require("@strapi/strapi");
const dataResponse_dto_1 = require("../../../shared/dto/dataResponse.dto");
exports.default = strapi_1.factories.createCoreService("api::interest.interest", ({ strapi }) => ({
    async createInterest(body) {
        try {
            const ticket = await strapi.db.query("api::ticket-master.ticket-master").findOne({
                where: { id: body === null || body === void 0 ? void 0 : body.ticketId, status: "issued" }
            });
            if (!ticket) {
                return new dataResponse_dto_1.DataResponseDto(null, "No ticket found");
            }
            const resArray = [];
            const interests = await strapi.db.query("api::interest.interest").findMany({
                where: { ticketId: body === null || body === void 0 ? void 0 : body.ticketId }
            });
            if (interests === null || interests === void 0 ? void 0 : interests.length) {
                for (const element of interests) {
                    await strapi.db.query("api::interest.interest").delete({
                        where: { id: element === null || element === void 0 ? void 0 : element.id }
                    });
                }
            }
            for (const interest of body.interests) {
                const data = await strapi.db.query("api::interest.interest").create({
                    data: {
                        label: interest === null || interest === void 0 ? void 0 : interest.label,
                        value: interest === null || interest === void 0 ? void 0 : interest.value,
                        ticketId: body === null || body === void 0 ? void 0 : body.ticketId,
                        publishedAt: new Date()
                    },
                });
                resArray.push(data);
            }
            return new dataResponse_dto_1.DataResponseDto(resArray, "Interests created successfully");
        }
        catch (error) {
            console.log(error);
            return new dataResponse_dto_1.DataResponseDto(null, "Something went wrong in our end please contact system administrator");
        }
    },
    async findInterestsByTicketId(ticketId) {
        try {
            const interestData = await strapi.db.query("api::interest.interest").findMany({
                where: { ticketId, is_deleted: false }
            });
            return new dataResponse_dto_1.DataResponseDto(interestData, "Interests fetched successfully");
        }
        catch (error) {
            console.log(error);
            return new dataResponse_dto_1.DataResponseDto(null, "Something went wrong in our end please contact system administrator");
        }
    },
    async softDelete(id) {
        try {
            const data = await strapi.db.query("api::interest.interest").update({
                where: { id, is_deleted: false },
                data: {
                    is_deleted: true,
                },
            });
            if (data) {
                return new dataResponse_dto_1.DataResponseDto(data, "interest deleted successfully");
            }
            else {
                return new dataResponse_dto_1.DataResponseDto(null);
            }
        }
        catch (error) {
            console.log(error);
            return new dataResponse_dto_1.DataResponseDto(null, "Something went wrong in our end please contact system administrator");
        }
    },
}));
