"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const strapi_1 = require("@strapi/strapi");
const moment_1 = __importDefault(require("moment"));
exports.default = strapi_1.factories.createCoreController("api::meeting-booking.meeting-booking", ({ strapi }) => ({
    createBooking: async (ctx) => {
        try {
            const data = await strapi
                .service("api::meeting-booking.meeting-booking")
                .createBooking(ctx.request.body);
            return ctx.send(data);
        }
        catch (error) {
            console.log(error);
        }
    },
    updateBooking: async (ctx) => {
        try {
            const { id } = ctx.params;
            if (!id) {
                return ctx.badRequest("ID is required");
            }
            const data = await strapi
                .service("api::meeting-booking.meeting-booking")
                .updateBooking(id, ctx.request.body);
            return ctx.send(data);
        }
        catch (error) {
            console.log(error);
        }
    },
    addAttendees: async (ctx) => {
        var _a;
        try {
            if (!((_a = ctx.request.body) === null || _a === void 0 ? void 0 : _a.bookingItemId)) {
                return ctx.badRequest("Booking Item ID is required");
            }
            const data = await strapi
                .service("api::meeting-booking.meeting-booking")
                .addAttendees(ctx.request.body);
            return ctx.send(data);
        }
        catch (error) {
            console.log(error);
        }
    },
    findAllBookings: async (ctx) => {
        try {
            const data = await strapi
                .service("api::meeting-booking.meeting-booking")
                .findAllBookings(ctx.request.query);
            return ctx.send(data);
        }
        catch (error) {
            console.log(error);
        }
    },
    findExportData: async (ctx) => {
        try {
            const data = await strapi.service("api::meeting-booking.meeting-booking").findExportData();
            return ctx.send(data);
        }
        catch (error) {
            console.log(error);
        }
    },
    softDelete: async (ctx) => {
        try {
            const { id } = ctx.params;
            if (!id) {
                return ctx.badRequest("ID is required");
            }
            const data = await strapi
                .service("api::meeting-booking.meeting-booking")
                .softDelete(id);
            return ctx.send(data);
        }
        catch (error) {
            console.log(error);
        }
    },
    findOneBooking: async (ctx) => {
        try {
            const { id } = ctx.params;
            if (!id) {
                return ctx.badRequest("ID is required");
            }
            const data = await strapi
                .service("api::meeting-booking.meeting-booking")
                .findOneBooking(id);
            return ctx.send(data);
        }
        catch (error) {
            console.log(error);
        }
    },
    generateICSfile: async (ctx) => {
        try {
            const { id } = ctx.params;
            const DTSTAMP = (0, moment_1.default)().unix();
            const data = await strapi
                .service("api::meeting-booking.meeting-booking")
                .generateICSfile(id);
            ctx.res.setHeader('Content-Type', 'text/calendar');
            ctx.set({
                'Content-Type': 'text/calendar',
                'Content-Disposition': `attachment; filename="meeting-reminder-${DTSTAMP}.ics"`,
            });
            return ctx.send(data);
        }
        catch (error) {
            console.log(error);
        }
    },
}));
