"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const strapi_1 = require("@strapi/strapi");
const dataResponse_dto_1 = require("../../../shared/dto/dataResponse.dto");
const moment_1 = __importDefault(require("moment"));
const axios = require("axios");
const uuid_1 = require("uuid");
exports.default = strapi_1.factories.createCoreService("api::meeting-booking.meeting-booking", ({ strapi }) => ({
    async createBooking(body) {
        try {
            const result = await strapi.db.transaction(async ({ trx }) => {
                var _a, _b;
                const bookingData = await strapi.entityService.create("api::meeting-booking.meeting-booking", {
                    data: {
                        meetingTitle: body === null || body === void 0 ? void 0 : body.meetingTitle,
                        contactPerson: body === null || body === void 0 ? void 0 : body.contactPerson,
                        countryCode: body === null || body === void 0 ? void 0 : body.countryCode,
                        phone: body === null || body === void 0 ? void 0 : body.phone,
                        company: body === null || body === void 0 ? void 0 : body.company,
                        email: body === null || body === void 0 ? void 0 : body.email,
                        status: "active",
                        totalAttendeeCount: body === null || body === void 0 ? void 0 : body.totalAttendeeCount,
                        publishedAt: new Date(),
                        meeting_room: body === null || body === void 0 ? void 0 : body.meeting_room,
                        portalId: body === null || body === void 0 ? void 0 : body.portalId
                    },
                    transacting: trx,
                });
                const emailData = [];
                emailData.push({ name: body === null || body === void 0 ? void 0 : body.contactPerson, email: body === null || body === void 0 ? void 0 : body.email });
                const bookingItems = [];
                if ((_a = body === null || body === void 0 ? void 0 : body.items) === null || _a === void 0 ? void 0 : _a.length) {
                    for (const item of body === null || body === void 0 ? void 0 : body.items) {
                        const bookingItem = await strapi.entityService.create("api::meeting-booking-item.meeting-booking-item", {
                            data: {
                                meeting_booking: bookingData.id,
                                meeting_room: item === null || item === void 0 ? void 0 : item.meetingRoomId,
                                attendeeCount: item === null || item === void 0 ? void 0 : item.attendeeCount,
                                status: "active",
                            },
                        });
                        if ((_b = item === null || item === void 0 ? void 0 : item.attendees) === null || _b === void 0 ? void 0 : _b.length) {
                            const attendeeDetails = [];
                            for (const attendee of item === null || item === void 0 ? void 0 : item.attendees) {
                                const attendeeData = await strapi.entityService.create("api::meeting-attendee.meeting-attendee", {
                                    data: {
                                        name: attendee.attendeeName,
                                        countryCode: attendee === null || attendee === void 0 ? void 0 : attendee.attendeeCountryCode,
                                        phone: attendee === null || attendee === void 0 ? void 0 : attendee.attendeePhone,
                                        company: attendee === null || attendee === void 0 ? void 0 : attendee.attendeeCompany,
                                        email: attendee === null || attendee === void 0 ? void 0 : attendee.attendeeEmail,
                                        meeting_booking_item: bookingItem === null || bookingItem === void 0 ? void 0 : bookingItem.id,
                                        meeting_room: item === null || item === void 0 ? void 0 : item.meetingRoomId
                                    },
                                });
                                if (attendee === null || attendee === void 0 ? void 0 : attendee.attendeeEmail) {
                                    emailData.push({ name: attendee.attendeeName, email: attendee === null || attendee === void 0 ? void 0 : attendee.attendeeEmail });
                                }
                                attendeeDetails.push(attendeeData);
                            }
                            bookingItems.push({ bookingItem, attendeeDetails });
                        }
                    }
                }
                const room = await strapi.entityService.update("api::meeting-room.meeting-room", body === null || body === void 0 ? void 0 : body.meeting_room, {
                    data: {
                        status: "booked"
                    },
                    populate: {
                        meeting_category: {
                            populate: {
                                venue: true
                            }
                        }
                    }
                });
                const [startTime, endTime] = room.slotTime.split('-').map(t => t.trim());
                const format = 'YYYY-MM-DD h:mm A';
                const timeFormat = 'h:mm A';
                const date = room.date;
                const sTime = (0, moment_1.default)(`${date} ${startTime}`, format).format(timeFormat);
                const eTime = (0, moment_1.default)(`${date} ${endTime}`, format)
                    .subtract(15, 'minutes')
                    .format(timeFormat);
                let mandrilURL = process.env.MANDRILL_SENT_MAIL_URL;
                const formattedDate = (0, moment_1.default)(room === null || room === void 0 ? void 0 : room.date)
                    .utcOffset("+05:30")
                    .format("Do MMMM YYYY");
                const emailPromises = emailData.map(async (item) => {
                    var _a, _b;
                    let emailPayload = {
                        key: process.env.MANDRILL_KEY,
                        template_name: process.env.MEETING_BOOKING_CONFIRMATION_TEMPLATE_NAME,
                        template_content: [],
                        message: {
                            to: [
                                {
                                    email: item === null || item === void 0 ? void 0 : item.email,
                                    name: item === null || item === void 0 ? void 0 : item.name,
                                    type: "to",
                                },
                            ],
                            from_email: "donotreply@adfw.com",
                            from_name: "Abu Dhabi Finance Week",
                            global_merge_vars: [
                                {
                                    name: "FIRSTNAME",
                                    content: item === null || item === void 0 ? void 0 : item.name,
                                },
                                {
                                    name: "MEETINGTITLE",
                                    content: body === null || body === void 0 ? void 0 : body.meetingTitle,
                                },
                                {
                                    name: "MEETINGDATE",
                                    content: formattedDate,
                                },
                                {
                                    name: "MEETINGTIME",
                                    content: `${sTime} - ${eTime}`
                                },
                                {
                                    name: "MEETINGROOM",
                                    content: room === null || room === void 0 ? void 0 : room.name,
                                },
                                {
                                    name: "MEETINGLOCATION",
                                    content: (_b = (_a = room === null || room === void 0 ? void 0 : room.meeting_category) === null || _a === void 0 ? void 0 : _a.venue) === null || _b === void 0 ? void 0 : _b.name,
                                },
                                {
                                    name: "ADDTOCALENDAR",
                                    content: `${process.env.SERVER_URL}generateICSfile/${bookingData === null || bookingData === void 0 ? void 0 : bookingData.id}`,
                                },
                            ],
                        },
                    };
                    return axios.post(mandrilURL, emailPayload);
                });
                await Promise.all(emailPromises);
                const response = {
                    bookingData,
                    bookingItems,
                };
                return new dataResponse_dto_1.DataResponseDto(response, "Booking placed successfully");
            });
            return result;
        }
        catch (error) {
            console.log(error);
            return new dataResponse_dto_1.DataResponseDto(null, "Something went wrong in our end please contact system administrator");
        }
    },
    async updateBooking(id, body) {
        try {
            const result = await strapi.db.transaction(async ({ trx }) => {
                var _a, _b;
                const existingBooking = await strapi
                    .query("api::meeting-booking.meeting-booking")
                    .findOne({
                    where: { id, is_deleted: false },
                });
                if (!existingBooking) {
                    return new dataResponse_dto_1.DataResponseDto(null, "No booking found");
                }
                const updatedBookingData = await strapi.entityService.update("api::meeting-booking.meeting-booking", id, {
                    data: {
                        meetingTitle: body === null || body === void 0 ? void 0 : body.meetingTitle,
                        contactPerson: body === null || body === void 0 ? void 0 : body.contactPerson,
                        countryCode: body === null || body === void 0 ? void 0 : body.countryCode,
                        phone: body === null || body === void 0 ? void 0 : body.phone,
                        company: body === null || body === void 0 ? void 0 : body.company,
                        email: body === null || body === void 0 ? void 0 : body.email,
                        totalAttendeeCount: body === null || body === void 0 ? void 0 : body.totalAttendeeCount,
                    },
                    transacting: trx,
                });
                const bookingItems = [];
                if ((_a = body === null || body === void 0 ? void 0 : body.items) === null || _a === void 0 ? void 0 : _a.length) {
                    for (const item of body === null || body === void 0 ? void 0 : body.items) {
                        const bookingItem = await strapi.entityService.update("api::meeting-booking-item.meeting-booking-item", item === null || item === void 0 ? void 0 : item.id, {
                            data: {
                                meeting_room: item === null || item === void 0 ? void 0 : item.meetingRoomId,
                                attendeeCount: item === null || item === void 0 ? void 0 : item.attendeeCount,
                            },
                        });
                        if ((_b = item === null || item === void 0 ? void 0 : item.attendees) === null || _b === void 0 ? void 0 : _b.length) {
                            const attendeeDetails = [];
                            for (const attendee of item === null || item === void 0 ? void 0 : item.attendees) {
                                if (attendee === null || attendee === void 0 ? void 0 : attendee.id) {
                                    const attendeeData = await strapi.entityService.update("api::meeting-attendee.meeting-attendee", attendee === null || attendee === void 0 ? void 0 : attendee.id, {
                                        data: {
                                            name: attendee.attendeeName,
                                            countryCode: attendee === null || attendee === void 0 ? void 0 : attendee.attendeeCountryCode,
                                            phone: attendee === null || attendee === void 0 ? void 0 : attendee.attendeePhone,
                                            company: attendee === null || attendee === void 0 ? void 0 : attendee.attendeeCompany,
                                            email: attendee === null || attendee === void 0 ? void 0 : attendee.attendeeEmail,
                                            meeting_booking_item: bookingItem === null || bookingItem === void 0 ? void 0 : bookingItem.id,
                                        },
                                    });
                                    attendeeDetails.push(attendeeData);
                                }
                                else {
                                    const attendeeData = await strapi.entityService.create("api::meeting-attendee.meeting-attendee", {
                                        data: {
                                            name: attendee.attendeeName,
                                            countryCode: attendee === null || attendee === void 0 ? void 0 : attendee.attendeeCountryCode,
                                            phone: attendee === null || attendee === void 0 ? void 0 : attendee.attendeePhone,
                                            company: attendee === null || attendee === void 0 ? void 0 : attendee.attendeeCompany,
                                            email: attendee === null || attendee === void 0 ? void 0 : attendee.attendeeEmail,
                                            meeting_booking_item: bookingItem === null || bookingItem === void 0 ? void 0 : bookingItem.id,
                                            meeting_room: item === null || item === void 0 ? void 0 : item.meetingRoomId
                                        },
                                    });
                                    attendeeDetails.push(attendeeData);
                                }
                            }
                            bookingItems.push({ bookingItem, attendeeDetails });
                        }
                    }
                }
            });
            return result;
        }
        catch (error) {
            console.log(error);
            return new dataResponse_dto_1.DataResponseDto(null, "Something went wrong in our end please contact system administrator");
        }
    },
    async cancelBooking(id) {
        try {
            const data = await strapi.db
                .query("api::meeting-booking.meeting-booking")
                .update({
                where: { id, is_deleted: false },
                data: {
                    status: "cancelled",
                },
            });
            if (!data) {
                return new dataResponse_dto_1.DataResponseDto(null);
            }
            const bookingItems = await strapi.db
                .query("api::meeting-booking.meeting-booking")
                .updateMany({
                where: { meeting_booking: id },
                data: {
                    status: "cancelled",
                },
            });
            const updatedRoom = await strapi.db
                .query("api::meeting-room.meeting-room")
                .update({
                where: { id, is_deleted: false },
                data: {
                    status: "open",
                },
            });
            return new dataResponse_dto_1.DataResponseDto(data, "meeting-booking cancelled successfully");
        }
        catch (error) {
            console.log(error);
            return new dataResponse_dto_1.DataResponseDto(null, "Something went wrong in our end please contact system administrator");
        }
    },
    async findExportData() {
        try {
            const data = await strapi.db
                .query("api::meeting-booking.meeting-booking")
                .findMany({
                where: { is_deleted: false,
                    status: {
                        $notIn: ["cancelled"]
                    }
                },
                orderBy: { id: "desc" },
            });
            if (!data) {
                return new dataResponse_dto_1.DataResponseDto(null);
            }
            return new dataResponse_dto_1.DataResponseDto(data, "meeting-booking data fetched successfully");
        }
        catch (error) {
            console.log(error);
            return new dataResponse_dto_1.DataResponseDto(null, "Something went wrong in our end please contact system administrator");
        }
    },
    async findAllBookings1(params) {
        try {
            const { page, pageSize, search, filters } = params;
            let limit = Number(pageSize) || 10;
            let pageNumber = Number(page) || 1;
            const offset = (Number(pageNumber) - 1) * Number(limit);
            const where = {
                is_deleted: false,
                status: {
                    $notIn: ["cancelled"]
                },
                ...(filters && Object.keys(filters).length > 0 && { ...filters }),
                ...(search &&
                    search.trim() && {
                    $or: [
                        { contactPerson: { $containsi: search } },
                        { company: { $containsi: search } },
                    ],
                }),
            };
            const data = await strapi.db
                .query("api::meeting-booking.meeting-booking")
                .findMany({
                where,
                offset,
                limit: limit,
                orderBy: { id: "desc" },
                populate: {
                    meeting_room: {
                        populate: {
                            meeting_category: {
                                populate: {
                                    venue: true
                                }
                            }
                        }
                    }
                }
            });
            if (!data) {
                return new dataResponse_dto_1.DataResponseDto(null);
            }
            const sortedData = data.sort((a, b) => {
                const dateA = new Date(a.meeting_room.date).getTime();
                const dateB = new Date(b.meeting_room.date).getTime();
                return dateA - dateB;
            });
            const totalDataCount = await strapi
                .query("api::meeting-booking.meeting-booking")
                .count({ where });
            const pageCount = Math.ceil(totalDataCount / limit);
            return new dataResponse_dto_1.DataResponseDto({
                data: sortedData,
                pagination: {
                    page: Number(pageNumber),
                    pageSize: Number(limit),
                    pageCount,
                    total: Number(totalDataCount),
                },
            }, "meeting-booking data fetched successfully");
        }
        catch (error) {
            console.log("error", error);
        }
    },
    async findOneBooking(id) {
        try {
            const data = await strapi.db
                .query("api::meeting-booking.meeting-booking")
                .findOne({
                where: { id,
                    is_deleted: false,
                    status: {
                        $notIn: ["cancelled"]
                    }
                },
                populate: {
                    meeting_room: true,
                    meeting_booking_items: {
                        meeting_attendees: true
                    }
                }
            });
            if (!data) {
                return new dataResponse_dto_1.DataResponseDto(null);
            }
            return new dataResponse_dto_1.DataResponseDto(data, "meeting-booking details fetched successfully");
        }
        catch (error) {
            console.log(error);
            return new dataResponse_dto_1.DataResponseDto(null, "Something went wrong in our end please contact system administrator");
        }
    },
    async addAttendees(body) {
        var _a;
        try {
            const bookingItem = await strapi.db
                .query("api::meeting-booking.meeting-booking")
                .findOne({
                where: {
                    id: body === null || body === void 0 ? void 0 : body.bookingItemId,
                    is_deleted: false,
                    status: {
                        $notIn: ["cancelled"]
                    }
                }
            });
            if (!bookingItem) {
                return new dataResponse_dto_1.DataResponseDto(null);
            }
            const attendeeDetails = [];
            if ((_a = body === null || body === void 0 ? void 0 : body.attendees) === null || _a === void 0 ? void 0 : _a.length) {
                for (const attendee of body === null || body === void 0 ? void 0 : body.attendees) {
                    let attendeeData;
                    if (attendee === null || attendee === void 0 ? void 0 : attendee.id) {
                        attendeeData = await strapi.entityService.update("api::meeting-attendee.meeting-attendee", attendee === null || attendee === void 0 ? void 0 : attendee.id, {
                            data: {
                                name: attendee.attendeeName,
                                countryCode: attendee === null || attendee === void 0 ? void 0 : attendee.attendeeCountryCode,
                                phone: attendee === null || attendee === void 0 ? void 0 : attendee.attendeePhone,
                                company: attendee === null || attendee === void 0 ? void 0 : attendee.attendeeCompany,
                                email: attendee === null || attendee === void 0 ? void 0 : attendee.attendeeEmail,
                                meeting_booking_item: body === null || body === void 0 ? void 0 : body.bookingItemId,
                                meeting_room: bookingItem === null || bookingItem === void 0 ? void 0 : bookingItem.meeting_room
                            },
                        });
                    }
                    else {
                        attendeeData = await strapi.entityService.create("api::meeting-attendee.meeting-attendee", {
                            data: {
                                name: attendee.attendeeName,
                                countryCode: attendee === null || attendee === void 0 ? void 0 : attendee.attendeeCountryCode,
                                phone: attendee === null || attendee === void 0 ? void 0 : attendee.attendeePhone,
                                company: attendee === null || attendee === void 0 ? void 0 : attendee.attendeeCompany,
                                email: attendee === null || attendee === void 0 ? void 0 : attendee.attendeeEmail,
                                meeting_booking_item: body === null || body === void 0 ? void 0 : body.bookingItemId,
                            },
                        });
                    }
                    attendeeDetails.push(attendeeData);
                }
            }
            else {
                return new dataResponse_dto_1.DataResponseDto(null, "Please provide data");
            }
            return new dataResponse_dto_1.DataResponseDto(attendeeDetails, "Attendees added successfully");
        }
        catch (error) {
            console.log(error);
            return new dataResponse_dto_1.DataResponseDto(null, "Something went wrong in our end please contact system administrator");
        }
    },
    async softDelete(id) {
        try {
            const result = await strapi.db.transaction(async ({ trx }) => {
                var _a, _b, _c;
                // fetch existing booking data
                const existingBooking = await strapi.db
                    .query("api::meeting-booking.meeting-booking")
                    .findOne({
                    where: {
                        id,
                        is_deleted: false,
                        status: {
                            $notIn: ["cancelled"]
                        }
                    },
                    populate: true,
                    orderBy: { id: "desc" },
                });
                // throw error if not
                if (!existingBooking) {
                    return new dataResponse_dto_1.DataResponseDto(null);
                }
                // update the meeting room slots status to open
                const meetingRoom = await strapi.db
                    .query("api::meeting-room.meeting-room")
                    .update({
                    where: { id: (_a = existingBooking === null || existingBooking === void 0 ? void 0 : existingBooking.meeting_room) === null || _a === void 0 ? void 0 : _a.id, is_deleted: false },
                    data: {
                        status: "open",
                    }
                });
                const attendeeIds = (_b = meetingRoom === null || meetingRoom === void 0 ? void 0 : meetingRoom.meeting_attendees) === null || _b === void 0 ? void 0 : _b.map(item => item.id);
                // update meeting booking entry's is_deleted field to true 
                const data = await strapi.db
                    .query("api::meeting-booking.meeting-booking")
                    .update({
                    where: { id, is_deleted: false },
                    data: {
                        is_deleted: true,
                        status: "cancelled"
                    }
                });
                const bookingItemIds = (_c = existingBooking === null || existingBooking === void 0 ? void 0 : existingBooking.meeting_booking_items) === null || _c === void 0 ? void 0 : _c.map(item => item.id);
                // update meeting booking items is_deleted field to true
                if (bookingItemIds.length) {
                    const updatedBookingItems = await strapi.db
                        .query("api::meeting-booking-item.meeting-booking-item")
                        .updateMany({
                        where: {
                            id: {
                                $in: [bookingItemIds]
                            },
                            is_deleted: false
                        },
                        data: {
                            is_deleted: true,
                            status: "cancelled"
                        },
                    });
                }
                if (attendeeIds === null || attendeeIds === void 0 ? void 0 : attendeeIds.length) {
                    // update meeting attendees is_deleted field to true
                    await strapi.db
                        .query("api::meeting-attendee.meeting-attendee")
                        .updateMany({
                        where: {
                            id: {
                                $in: [attendeeIds]
                            }
                        },
                        data: {
                            is_deleted: true,
                        },
                    });
                }
                return new dataResponse_dto_1.DataResponseDto(data, "meeting-booking deleted successfully");
            });
            return result;
        }
        catch (error) {
            console.log(error);
            return new dataResponse_dto_1.DataResponseDto(null, "Something went wrong in our end please contact system administrator");
        }
    },
    async generateICSfile(id) {
        var _a, _b;
        try {
            const data = await strapi.db
                .query("api::meeting-booking.meeting-booking")
                .findOne({
                where: { id, is_deleted: false, status: "active" },
                populate: {
                    meeting_room: true,
                    meeting_booking_items: {
                        meeting_attendees: true
                    }
                }
            });
            if (!data) {
                return new dataResponse_dto_1.DataResponseDto(null);
            }
            // Format dates
            const format_from = 'YYYY-MM-DD h:mm A';
            const format_to = 'YYYYMMDDTHHmmss';
            const date = data.meeting_room.date;
            const [startTime, endTime] = data.meeting_room.slotTime.split('-').map(t => t.trim());
            const DTSTAMP = (0, moment_1.default)().format(format_to) + 'Z';
            const DTSTART = (0, moment_1.default)(`${date} ${startTime}`, format_from).format(format_to);
            const DTEND = (0, moment_1.default)(`${date} ${endTime}`, format_from)
                .subtract(15, 'minutes')
                .format(format_to);
            const UID = `${(0, uuid_1.v4)()}@adfw.com`;
            // Get attendees
            const attendees = ((_b = (_a = data.meeting_booking_items) === null || _a === void 0 ? void 0 : _a[0]) === null || _b === void 0 ? void 0 : _b.meeting_attendees) || [];
            const attendeesList = attendees.map(attendee => `ATTENDEE;CN=${attendee.name};ROLE=REQ-PARTICIPANT;PARTSTAT=NEEDS-ACTION:mailto:${attendee.email}`).join('\n');
            const icsContent = [
                'BEGIN:VCALENDAR',
                'VERSION:2.0',
                'PRODID:-//ADFW//Meeting Calendar//EN',
                'CALSCALE:GREGORIAN',
                // 'METHOD:REQUEST',
                'BEGIN:VTIMEZONE',
                'TZID:Asia/Dubai',
                'TZURL:http://tzurl.org/zoneinfo-outlook/Asia/Dubai',
                'X-LIC-LOCATION:Asia/Dubai',
                'BEGIN:STANDARD',
                'TZOFFSETFROM:+0400',
                'TZOFFSETTO:+0400',
                'TZNAME:+04',
                'DTSTART:19700101T000000',
                'RRULE:FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU',
                'END:STANDARD',
                'END:VTIMEZONE',
                'BEGIN:VEVENT',
                `DTSTAMP:${DTSTAMP}`,
                `UID:${UID}`,
                `DTSTART;TZID=Asia/Dubai:${DTSTART}`,
                `DTEND;TZID=Asia/Dubai:${DTEND}`,
                `SUMMARY:${data.meetingTitle}`,
                `DESCRIPTION:Please arrive 10 mins before your meeting start time.`,
                `LOCATION:${data.meeting_room.location || 'TBD'}`,
                // `ORGANIZER:${data.organizer || 'mailto:organizer@adfw.com'}`,
                attendeesList,
                // 'SEQUENCE:0',
                // 'STATUS:CONFIRMED',
                // 'TRANSP:OPAQUE',
                'BEGIN:VALARM',
                'ACTION:DISPLAY',
                `DESCRIPTION:Reminder: ${data.meetingTitle}`,
                'TRIGGER:-PT5M',
                'END:VALARM',
                'END:VEVENT',
                'END:VCALENDAR'
            ].join('\r\n');
            return icsContent.trim();
        }
        catch (error) {
            console.log(error);
            return new dataResponse_dto_1.DataResponseDto(null, "Something went wrong in our end please contact system administrator");
        }
    },
    // new
    async findAllBookings(params) {
        try {
            const { page, pageSize, search, portalId } = params;
            let limit = Number(pageSize) || 10;
            let pageNumber = Number(page) || 1;
            const offset = (Number(pageNumber) - 1) * Number(limit);
            let query = strapi.db.connection('meeting_bookings as mb')
                .select('mb.id AS id', 'mb.meeting_title AS meetingTitle', 'mb.contact_person AS contactPerson', 'mb.company as company', 'mb.email as email', 'mr.name as roomName', 'mr.location as location', 'mr.date as date', 'mr.slot_time as slotTime', 'mr.time_short as timeShort', 'v.name AS venue')
                // meeting_bookings_meeting_room_links
                .join('meeting_bookings_meeting_room_links as mbrl', 'mbrl.id', 'mb.id')
                // meeting room
                .join('meeting_rooms as mr', 'mr.id', 'mbrl.meeting_room_id')
                // meeting_rooms_meeting_category_links
                .join('meeting_rooms_meeting_category_links as mrmcl', 'mrmcl.meeting_room_id', 'mbrl.meeting_room_id')
                //meeting_categories_venue_links
                .join('meeting_categories_venue_links as mcvl', 'mcvl.meeting_category_id', 'mrmcl.meeting_category_id')
                // venues
                .join('venues as v', 'v.id', 'mcvl.venue_id')
                .andWhere({
                'mb.is_deleted': 'false',
                'mb.portal_id': `${portalId}`
            })
                .limit(limit)
                .offset(offset)
                .orderBy('mb.id', 'desc');
            ;
            if (search && search.trim()) {
                query.whereRaw('(mb.contact_person ILIKE ? OR mb.company ILIKE ? OR v.name ILIKE ?)', [`%${search}%`, `%${search}%`, `%${search}%`]);
            }
            const data = await query;
            // fetch the count of all data 
            let query2 = strapi.db.connection('meeting_bookings as mb')
                .count('mb.id as count')
                // meeting_bookings_meeting_room_links
                .join('meeting_bookings_meeting_room_links as mbrl', 'mbrl.id', 'mb.id')
                // meeting room
                .join('meeting_rooms as mr', 'mr.id', 'mbrl.meeting_room_id')
                // meeting_rooms_meeting_category_links
                .join('meeting_rooms_meeting_category_links as mrmcl', 'mrmcl.meeting_room_id', 'mbrl.meeting_room_id')
                //meeting_categories_venue_links
                .join('meeting_categories_venue_links as mcvl', 'mcvl.meeting_category_id', 'mrmcl.meeting_category_id')
                // venues
                .join('venues as v', 'v.id', 'mcvl.venue_id')
                .andWhere({
                'mb.is_deleted': 'false',
                'mb.portal_id': `${portalId}`
            });
            if (search && search.trim()) {
                query2.whereRaw('(mb.contact_person ILIKE ? OR mb.company ILIKE ? OR v.name ILIKE ?)', [`%${search}%`, `%${search}%`, `%${search}%`]);
            }
            const dataCount = await query2;
            // total count of data
            const totalDataCount = Number(dataCount[0].count);
            // calculate the total page count
            const pageCount = Math.ceil(totalDataCount / limit);
            return new dataResponse_dto_1.DataResponseDto({
                data,
                pagination: {
                    page: Number(pageNumber),
                    pageSize: Number(limit),
                    pageCount,
                    total: Number(totalDataCount),
                },
            }, "meeting-booking data fetched successfully");
        }
        catch (error) {
            console.log("error", error);
        }
    },
}));
