"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const { createCoreRouter } = require("@strapi/strapi").factories;
const defaultRouter = createCoreRouter("api::meeting-category.meeting-category");
const customRouter = (innerRouter, extraRoutes = []) => {
    let routes;
    return {
        get prefix() {
            return innerRouter.prefix;
        },
        get routes() {
            if (!routes)
                routes = innerRouter.routes.concat(extraRoutes);
            return routes;
        },
    };
};
const extraRoutes = [
    {
        method: "GET",
        path: "/meeting-category/findOne/:id",
        handler: "meeting-category.findOneCategory",
        config: {
            auth: false,
            policies: [],
            middlewares: [],
        },
    },
    {
        method: "GET",
        path: "/meeting-category/all",
        handler: "meeting-category.findAllCategories",
        config: {
            auth: false,
            policies: [],
            middlewares: [],
        },
    },
    {
        method: "GET",
        path: "/meeting-category/export",
        handler: "meeting-category.findExportData",
        config: {
            auth: false,
            policies: [],
            middlewares: [],
        },
    },
    {
        method: "POST",
        path: "/meeting/create",
        handler: "meeting-category.createCategoryWithRooms",
        config: {
            auth: false,
            policies: [],
            middlewares: [],
        },
    },
    {
        method: "GET",
        path: "/meeting-category/remove/:id",
        handler: "meeting-category.softDelete",
        config: {
            auth: false,
            policies: [],
            middlewares: [],
        },
    },
    {
        method: "PUT",
        path: "/meeting/update/:id",
        handler: "meeting-category.updateCategoryWithRooms",
        config: {
            auth: false,
            policies: [],
            middlewares: [],
        },
    },
];
exports.default = customRouter(defaultRouter, extraRoutes);
