"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const strapi_1 = require("@strapi/strapi");
exports.default = strapi_1.factories.createCoreController("api::meeting-portal.meeting-portal", ({ strapi }) => ({
    findAllPortals: async (ctx) => {
        try {
            const data = await strapi
                .service("api::meeting-portal.meeting-portal")
                .findAllPortals(ctx.request.query);
            return ctx.send(data);
        }
        catch (error) {
            console.log(error);
        }
    },
    findExportData: async (ctx) => {
        try {
            const data = await strapi.service("api::meeting-portal.meeting-portal").findExportData();
            return ctx.send(data);
        }
        catch (error) {
            console.log(error);
        }
    },
    softDelete: async (ctx) => {
        try {
            const { id } = ctx.params;
            if (!id) {
                return ctx.badRequest("ID is required");
            }
            const data = await strapi
                .service("api::meeting-portal.meeting-portal")
                .softDelete(id);
            return ctx.send(data);
        }
        catch (error) {
            console.log(error);
        }
    },
}));
