"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const strapi_1 = require("@strapi/strapi");
const dataResponse_dto_1 = require("../../../shared/dto/dataResponse.dto");
exports.default = strapi_1.factories.createCoreService("api::meeting-portal.meeting-portal", ({ strapi }) => ({
    async findExportData() {
        try {
            const data = await strapi.db.query("api::meeting-portal.meeting-portal").findMany({
                where: { is_deleted: false },
                orderBy: { id: "desc" },
            });
            return new dataResponse_dto_1.DataResponseDto(data, "meeting-portal data fetched successfully");
        }
        catch (error) {
            console.log(error);
            return new dataResponse_dto_1.DataResponseDto(null, "Something went wrong in our end please contact system administrator");
        }
    },
    async findAllPortals(params) {
        try {
            const { page, pageSize, search, filters } = params;
            let limit = Number(pageSize) || 10;
            let pageNumber = Number(page) || 1;
            const offset = (Number(pageNumber) - 1) * Number(limit);
            const where = {
                is_deleted: false,
                ...(filters && Object.keys(filters).length > 0 && { ...filters }),
                ...(search &&
                    search.trim() && {
                    $or: [
                        { title: { $containsi: search } },
                        { portalId: { $containsi: search } }
                    ],
                }),
            };
            const data = await strapi.db.query("api::meeting-portal.meeting-portal").findMany({
                where,
                offset,
                limit: limit,
                orderBy: { id: "desc" },
                populate: {
                    creator: true,
                    modifiedBy: true
                }
            });
            if (data) {
                const totalDataCount = await strapi
                    .query("api::meeting-portal.meeting-portal")
                    .count({ where });
                const pageCount = Math.ceil(totalDataCount / limit);
                return new dataResponse_dto_1.DataResponseDto({
                    data,
                    pagination: {
                        page: Number(pageNumber),
                        pageSize: Number(limit),
                        pageCount,
                        total: Number(totalDataCount),
                    },
                }, "meeting-portal data fetched successfully");
            }
            else {
                return new dataResponse_dto_1.DataResponseDto(null);
            }
        }
        catch (error) {
            console.log("error", error);
        }
    },
    async softDelete(id) {
        try {
            const data = await strapi.db
                .query("api::meeting-portal.meeting-portal")
                .update({
                where: { id, is_deleted: false },
                data: {
                    is_deleted: true,
                },
            });
            if (data) {
                return new dataResponse_dto_1.DataResponseDto(data, "meeting-portal deleted successfully");
            }
            else {
                return new dataResponse_dto_1.DataResponseDto(null);
            }
        }
        catch (error) {
            console.log(error);
            return new dataResponse_dto_1.DataResponseDto(null, "Something went wrong in our end please contact system administrator");
        }
    }
}));
