"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const strapi_1 = require("@strapi/strapi");
exports.default = strapi_1.factories.createCoreController("api::notification-read.notification-read", ({ strapi }) => ({
    findUreadMessageCountById: async (ctx) => {
        try {
            const { id } = ctx.params;
            if (!id) {
                return ctx.badRequest("ID is required");
            }
            const data = await strapi.service("api::notification-read.notification-read").findUreadMessageCountById(id);
            return ctx.send(data);
        }
        catch (error) {
            console.log(error);
        }
    },
    findAllByUser: async (ctx) => {
        try {
            const { id } = ctx.params;
            if (!id) {
                return ctx.badRequest("ID is required");
            }
            const data = await strapi.service("api::notification-read.notification-read").findAllByUser(id);
            return ctx.send(data);
        }
        catch (error) {
            console.log(error);
        }
    },
    markAllReadByUser: async (ctx) => {
        try {
            const data = await strapi.service("api::notification-read.notification-read").markAllReadByUser(ctx.request.body);
            return ctx.send(data);
        }
        catch (error) {
            console.log(error);
        }
    },
    clearAllNotificationsByUser: async (ctx) => {
        try {
            const { id } = ctx.params;
            if (!id) {
                return ctx.badRequest("ID is required");
            }
            const data = await strapi.service("api::notification-read.notification-read").clearAllNotificationsByUser(id);
            return ctx.send(data);
        }
        catch (error) {
            console.log(error);
        }
    },
    softDelete: async (ctx) => {
        try {
            const { id } = ctx.params;
            if (!id) {
                return ctx.badRequest("ID is required");
            }
            const data = await strapi.service("api::notification-read.notification-read").softDelete(id);
            return ctx.send(data);
        }
        catch (error) {
            console.log(error);
        }
    },
}));
