"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const strapi_1 = require("@strapi/strapi");
const defaultRouter = strapi_1.factories.createCoreRouter('api::notification-read.notification-read');
const customRouter = (innerRouter, extraRoutes = []) => {
    let routes;
    return {
        get prefix() {
            return innerRouter.prefix;
        },
        get routes() {
            if (!routes)
                routes = innerRouter.routes.concat(extraRoutes);
            return routes;
        },
    };
};
const extraRoutes = [
    {
        method: "POST",
        path: "/notification-reads/mark-all-read",
        handler: "notification-read.markAllReadByUser",
        config: {
            policies: [],
        },
    },
    {
        method: "GET",
        path: "/notification-reads/findAllByUser/:id",
        handler: "notification-read.findAllByUser",
        config: {
            policies: [],
        },
    },
    {
        method: "DELETE",
        path: "/notification-reads/clear-all-notifications/:id",
        handler: "notification-read.clearAllNotificationsByUser",
        config: {
            policies: [],
        },
    },
    {
        method: "GET",
        path: "/notification-reads/remove/:id",
        handler: "notification-read.softDelete",
        config: {
            policies: [],
        },
    },
    {
        method: "GET",
        path: "/unread-notification-count/:id",
        handler: "notification-read.findUreadMessageCountById",
        config: {
            policies: [],
        },
    },
];
exports.default = customRouter(defaultRouter, extraRoutes);
