"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const strapi_1 = require("@strapi/strapi");
const dataResponse_dto_1 = require("../../../shared/dto/dataResponse.dto");
exports.default = strapi_1.factories.createCoreService("api::notification-read.notification-read", ({ strapi }) => ({
    async softDelete(id) {
        try {
            // set is_deleted field to true for a particular entry with the id
            const data = await strapi.db.query("api::notification-read.notification-read").update({
                where: { id, is_deleted: false },
                data: {
                    is_deleted: true,
                },
            });
            if (data) {
                return new dataResponse_dto_1.DataResponseDto(data, "notification read data deleted successfully");
            }
            else {
                return new dataResponse_dto_1.DataResponseDto(null);
            }
        }
        catch (error) {
            console.log(error);
            return new dataResponse_dto_1.DataResponseDto(null, "Something went wrong in our end please contact system administrator");
        }
    },
    async findAllByUser(id) {
        try {
            // fetch all notifications by tiket id
            const knex = strapi.db.connection;
            const data = await knex("notification_reads as nr")
                .select('nr.id', 'n.id as notificationId', 'n.title', 'n.description', 'n.logo', 'n.date', 'nrtl.ticket_master_id as tickerId', 'nr.is_read as isRead')
                .join('notification_reads_notification_id_links as nrnl', 'nrnl.notification_read_id', 'nr.id')
                .join('notifications as n', 'n.id', 'nrnl.notification_id')
                .join('notification_reads_ticket_id_links as nrtl', 'nrtl.notification_read_id', 'nrnl.notification_read_id')
                .where({
                'n.is_deleted': false,
                'nr.is_deleted': false,
                'nrtl.ticket_master_id': id
            })
                .orderBy('date', 'desc');
            return new dataResponse_dto_1.DataResponseDto(data, "Notifications fetched successfully");
        }
        catch (error) {
            console.log(error);
            return new dataResponse_dto_1.DataResponseDto(null, "Something went wrong in our end please contact system administrator");
        }
    },
    async clearAllNotificationsByUser(id) {
        try {
            const knex = strapi.db.connection;
            const notificationReadData = await knex("notification_reads")
                .update({ is_deleted: true })
                .whereIn("id", knex("notification_reads_ticket_id_links")
                .select("notification_read_id")
                .where("ticket_master_id", id));
            return new dataResponse_dto_1.DataResponseDto(notificationReadData, "notification read data deleted successfully");
        }
        catch (error) {
            console.log(error);
            return new dataResponse_dto_1.DataResponseDto(null, "Something went wrong in our end please contact system administrator");
        }
    },
    async markAllReadByUser(body) {
        try {
            if (!Array.isArray(body.notificationIds)) {
                return new dataResponse_dto_1.DataResponseDto(null, "Missing required parameters");
            }
            const notificationReadData = await strapi.db.query('api::notification-read.notification-read')
                .updateMany({
                where: {
                    id: {
                        $in: body.notificationIds
                    }
                },
                data: {
                    isRead: true
                }
            });
            return new dataResponse_dto_1.DataResponseDto(notificationReadData, "All notifications marked as read successfully");
        }
        catch (error) {
            console.log(error);
            return new dataResponse_dto_1.DataResponseDto(null, "Something went wrong in our end please contact system administrator");
        }
    },
    async findUreadMessageCountById(id) {
        try {
            const data = await strapi.db.query("api::notification-read.notification-read").count({
                where: {
                    ticket_id: id,
                    isRead: false,
                    is_deleted: false
                }
            });
            return new dataResponse_dto_1.DataResponseDto({ count: data, unreadStatus: data > 0 }, "notification unread read data fetched successfully");
        }
        catch (error) {
            console.log(error);
            return new dataResponse_dto_1.DataResponseDto(null, "Something went wrong in our end please contact system administrator");
        }
    }
}));
