"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const strapi_1 = require("@strapi/strapi");
exports.default = strapi_1.factories.createCoreController("api::notification.notification", ({ strapi }) => ({
    findAllNotifications: async (ctx) => {
        try {
            const data = await strapi
                .service("api::notification.notification")
                .findAllNotifications(ctx.request.query);
            return ctx.send(data);
        }
        catch (error) {
            console.log(error);
        }
    },
    createNotification: async (ctx) => {
        try {
            const data = await strapi
                .service("api::notification.notification")
                .createNotification(ctx.request.body);
            return ctx.send(data);
        }
        catch (error) {
            console.log(error);
        }
    },
    updateNotification: async (ctx) => {
        try {
            const { id } = ctx.params;
            if (!id) {
                return ctx.badRequest("ID is required");
            }
            const data = await strapi
                .service("api::notification.notification")
                .updateNotification(id, ctx.request.body);
            return ctx.send(data);
        }
        catch (error) {
            console.log(error);
        }
    },
    softDelete: async (ctx) => {
        try {
            const { id } = ctx.params;
            if (!id) {
                return ctx.badRequest("ID is required");
            }
            const data = await strapi
                .service("api::notification.notification")
                .softDelete(id);
            return ctx.send(data);
        }
        catch (error) {
            console.log(error);
        }
    },
    testCreateNotification: async (ctx) => {
        try {
            const data = await strapi
                .service("api::notification.notification")
                .testCreateNotification(ctx.request.body);
            return ctx.send(data);
        }
        catch (error) {
            console.log(error);
        }
    },
}));
