"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const strapi_1 = require("@strapi/strapi");
const defaultRouter = strapi_1.factories.createCoreRouter('api::notification.notification');
const customRouter = (innerRouter, extraRoutes = []) => {
    let routes;
    return {
        get prefix() {
            return innerRouter.prefix;
        },
        get routes() {
            if (!routes)
                routes = innerRouter.routes.concat(extraRoutes);
            return routes;
        },
    };
};
const extraRoutes = [
    {
        method: "POST",
        path: "/notifications/create",
        handler: "notification.createNotification",
        config: {
            auth: false,
            policies: [],
            middlewares: [],
        },
    },
    {
        method: "POST",
        path: "/test-notification",
        handler: "notification.testCreateNotification",
        config: {
            auth: false,
            policies: [],
            middlewares: [],
        },
    },
    {
        method: "PUT",
        path: "/notifications/update/:id",
        handler: "notification.updateNotification",
        config: {
            auth: false,
            policies: [],
            middlewares: [],
        },
    },
    {
        method: "GET",
        path: "/notifications/remove/:id",
        handler: "notification.softDelete",
        config: {
            auth: false,
            policies: [],
            middlewares: [],
        },
    },
    {
        method: "GET",
        path: "/notifications/remove/:id",
        handler: "notification.softDelete",
        config: {
            auth: false,
            policies: [],
            middlewares: [],
        },
    },
    {
        method: "GET",
        path: "/notification/all",
        handler: "notification.findAllNotifications",
        config: {
            auth: false,
            policies: [],
            middlewares: [],
        },
    },
];
exports.default = customRouter(defaultRouter, extraRoutes);
