"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const strapi_1 = require("@strapi/strapi");
const { v4: uuidv4 } = require("uuid");
exports.default = strapi_1.factories.createCoreController("api::order.order", ({ strapi }) => ({
    findAllOrders: async (ctx) => {
        try {
            const data = await strapi
                .service("api::order.order")
                .findAllOrders(ctx.request.query);
            return ctx.send(data);
        }
        catch (error) {
            console.log(error);
        }
    },
    findExportData: async (ctx) => {
        try {
            const data = await strapi.service("api::order.order").findExportData(ctx.request.query);
            return ctx.send(data);
        }
        catch (error) {
            console.log(error);
        }
    },
    checkTicketData: async (ctx) => {
        try {
            const { email, id } = ctx.request.query;
            if (!email) {
                return ctx.badRequest("Email is required");
            }
            const data = await strapi
                .service("api::order.order")
                .checkTicketData(email, id);
            return ctx.send(data);
        }
        catch (error) {
            console.log(error);
        }
    },
    findOrderDetails: async (ctx) => {
        try {
            const { id } = ctx.params;
            if (!id) {
                return ctx.badRequest("ID is required");
            }
            const data = await strapi
                .service("api::order.order")
                .findOrderDetails(id);
            return ctx.send(data);
        }
        catch (error) {
            console.log(error);
        }
    },
    softDelete: async (ctx) => {
        try {
            const { id } = ctx.params;
            if (!id) {
                return ctx.badRequest("ID is required");
            }
            const data = await strapi.service("api::order.order").softDelete(id);
            return ctx.send(data);
        }
        catch (error) {
            console.log(error);
        }
    },
    updateOrderStatus: async (ctx) => {
        try {
            const { OrderNumber } = ctx.params;
            if (!OrderNumber) {
                return ctx.badRequest("Order Number is required");
            }
            const { status, userId } = ctx.request.body;
            if (!status) {
                return ctx.badRequest("Status is required");
            }
            // const {userAccess} = ctx.state.user;
            const user = await strapi
                .query("plugin::users-permissions.user")
                .findOne({
                where: { id: userId, is_deleted: false },
            });
            if (!user) {
                return ctx.notFound('User not found');
            }
            const userAccess = user === null || user === void 0 ? void 0 : user.session_access;
            const data = await strapi
                .service("api::order.order")
                .updateOrderStatus(OrderNumber, status, userAccess, userId);
            return ctx.send(data);
        }
        catch (error) {
            console.log(error);
        }
    },
    // Generate a random 6 digit number
    getNumber: async (ctx) => {
        var _a;
        const uuid = uuidv4();
        const sixDigitUUID = (_a = uuid.replace(/-/g, "").slice(0, 6)) === null || _a === void 0 ? void 0 : _a.toUpperCase();
        const ticketNumber = `B${sixDigitUUID}`;
        return ctx.send(ticketNumber);
    },
}));
