module.exports = {
    createStripePaymentIntent: async (ctx) => {
        try {
            const data = await strapi
                .service("api::payment-gateway.payment-gateway")
                .createStripePaymentIntent(ctx.request.body);
            return ctx.send(data);
        }
        catch (error) {
            console.log(error);
        }
    },
    confirmStripePayment: async (ctx) => {
        try {
            const data = await strapi
                .service("api::payment-gateway.payment-gateway")
                .confirmStripePayment(ctx.request.body);
            return ctx.send(data);
        }
        catch (error) {
            console.log(error);
        }
    },
    createStripePaymentLink: async (ctx) => {
        try {
            const data = await strapi
                .service("api::payment-gateway.payment-gateway")
                .createStripePaymentLink(ctx.request.body);
            return ctx.send(data);
        }
        catch (error) {
            console.log(error);
        }
    },
    retrieveSession: async (ctx) => {
        try {
            const { sessionId } = ctx.params;
            if (!sessionId) {
                return ctx.badRequest("Session ID is required");
            }
            const plain = Buffer.from(sessionId, "base64").toString("utf8");
            let paymentId = "";
            if (plain) {
                paymentId = plain === null || plain === void 0 ? void 0 : plain.split("=")[1];
            }
            const data = await strapi
                .service("api::payment-gateway.payment-gateway")
                .retrieveSession(paymentId);
            return ctx.send(data);
        }
        catch (error) {
            return ctx.badRequest("An error occurred while retrieving the session.");
        }
    },
};
