"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const dataResponse_dto_1 = require("../../../shared/dto/dataResponse.dto");
const stripe = require("stripe")(process.env.STRIPE_SECRET_KEY_TEST);
module.exports = {
    async createStripePaymentIntent(body) {
        try {
            if (body.amount && body.currency) {
                const paymentIntent = await stripe.paymentIntents.create({
                    amount: Number(body.amount) * 100,
                    currency: body === null || body === void 0 ? void 0 : body.currency.toLowerCase(),
                    automatic_payment_methods: {
                        enabled: true,
                        allow_redirects: "never",
                    },
                });
                // await strapi.entityService.create("api::payment-log.payment-log", {
                //   data: {
                //     paymentId: paymentIntent.id,
                //     amount: paymentIntent.amount,
                //     publishedAt: new Date(),
                //   },
                // });
                return new dataResponse_dto_1.DataResponseDto(paymentIntent, "payment intent created successfully");
            }
            else {
                return new dataResponse_dto_1.DataResponseDto(null, "amount and currency not found");
            }
        }
        catch (error) {
            console.log(error);
            return new dataResponse_dto_1.DataResponseDto(null, "Something went wrong in our end please contact system administrator");
        }
    },
    async confirmStripePayment(body) {
        try {
            if (!body.paymentIntentId) {
                return new dataResponse_dto_1.DataResponseDto(null, "payment intent id not found");
            }
            const confirmation = await stripe.paymentIntents.retrieve(body.paymentIntentId);
            // const updatedPaymentLog = await strapi.db
            //   .query("api::payment-log.payment-log")
            //   .update({
            //     where: {
            //       paymentId: body.paymentIntentId,
            //     },
            //     data: {
            //       status: confirmation.status,
            //       details: confirmation,
            //     },
            //   });
            if (confirmation.status !== "succeeded") {
                return new dataResponse_dto_1.DataResponseDto(confirmation, "payment failed");
            }
            return new dataResponse_dto_1.DataResponseDto(confirmation, "payment confirmed successfully");
        }
        catch (error) {
            console.log(error);
            return new dataResponse_dto_1.DataResponseDto(null, "Something went wrong in our end please contact system administrator");
        }
    },
    async createStripePaymentLink(body) {
        try {
            const { amount, currency, quantity, ticketName } = body;
            if (!amount || !currency || !quantity) {
                return new dataResponse_dto_1.DataResponseDto(null, "amount or currency is not provided");
            }
            const lineItems = [
                {
                    price_data: {
                        currency: currency.toLowerCase(),
                        product_data: {
                            name: ticketName,
                        },
                        unit_amount: amount * 100,
                    },
                    quantity: quantity,
                },
                //   {
                //     price_data: {
                //       currency: currency.toLowerCase(),
                //       product_data: {
                //           name: "Service Charge"
                //       },
                //       unit_amount: 1
                //   },
                //   quantity: 1
                // },
            ];
            const checkoutData = await stripe.checkout.sessions.create({
                payment_method_types: ["card"],
                currency: currency,
                mode: "payment",
                success_url: `${process.env.STRIPE_SUCCESS_URL}?session_id={CHECKOUT_SESSION_ID}&payment_status=success`,
                cancel_url: `${process.env.STRIPE_CANCEL_URL}?session_id={CHECKOUT_SESSION_ID}&payment_status=cancelled`,
                line_items: lineItems,
            });
            // if (checkoutData.url) {
            //   await strapi.entityService.create("api::payment-log.payment-log", {
            //     data: {
            //       paymentId: checkoutData.id,
            //       amount: checkoutData.amount_total,
            //       publishedAt: new Date(),
            //     },
            //   });
            // }
            return new dataResponse_dto_1.DataResponseDto(checkoutData.url, "Link created successfully!");
        }
        catch (error) {
            console.error("Error =====>:", error);
            return new dataResponse_dto_1.DataResponseDto(null, "Something went wrong in our end please contact system administrator");
        }
    },
    async retrieveSession(sessionId) {
        try {
            const session = await stripe.checkout.sessions.retrieve(sessionId);
            // await strapi.db.query("api::payment-log.payment-log").update({
            //   where: {
            //     paymentId: sessionId,
            //   },
            //   data: {
            //     status: session.payment_status,
            //     details: session,
            //   },
            // });
            return new dataResponse_dto_1.DataResponseDto({ payment_status: session.payment_status }, "successfully retrieved!");
        }
        catch (error) {
            console.log(error);
            return new dataResponse_dto_1.DataResponseDto(null, "Something went wrong in our end please contact system administrator");
        }
    },
};
