"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const strapi_1 = require("@strapi/strapi");
exports.default = strapi_1.factories.createCoreController("api::payment-log.payment-log", ({ strapi }) => ({
    createLog: async (ctx) => {
        try {
            const data = await strapi
                .service("api::payment-log.payment-log")
                .createLog(ctx.request.body);
            return ctx.send(data);
        }
        catch (error) {
            console.log(error);
        }
    },
    updateLogStatus: async (ctx) => {
        try {
            const { orderId } = ctx.params;
            if (!orderId)
                return ctx.send("orderId is required");
            const data = await strapi
                .service("api::payment-log.payment-log")
                .updateLogStatus(orderId);
            return ctx.send(data);
        }
        catch (error) {
            console.log(error);
        }
    },
    findExportData: async (ctx) => {
        try {
            const data = await strapi
                .service("api::payment-log.payment-log")
                .findExportData();
            return ctx.send(data);
        }
        catch (error) {
            console.log(error);
        }
    },
    findAllLogs: async (ctx) => {
        try {
            const data = await strapi
                .service("api::payment-log.payment-log")
                .findAllLogs(ctx.request.query);
            return ctx.send(data);
        }
        catch (error) {
            console.log(error);
        }
    },
    syncSalesData: async (ctx) => {
        try {
            const data = await strapi
                .service("api::payment-log.payment-log")
                .syncSalesData(ctx.request.body);
            return ctx.send(data);
        }
        catch (error) {
            console.log(error);
        }
    },
}));
