"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const strapi_1 = require("@strapi/strapi");
const defaultRouter = strapi_1.factories.createCoreRouter('api::payment-log.payment-log');
const customRouter = (innerRouter, extraRoutes = []) => {
    let routes;
    return {
        get prefix() {
            return innerRouter.prefix;
        },
        get routes() {
            if (!routes)
                routes = innerRouter.routes.concat(extraRoutes);
            return routes;
        },
    };
};
const extraRoutes = [
    {
        method: "GET",
        path: "/payment-log/export",
        handler: "payment-log.findExportData",
        config: {
            auth: false,
            policies: [],
            middlewares: [],
        },
    },
    {
        method: "POST",
        path: "/payment-log/create",
        handler: "payment-log.createLog",
        config: {
            auth: false,
            policies: [],
            middlewares: [],
        },
    },
    {
        method: "GET",
        path: "/payment-log/status/:orderId",
        handler: "payment-log.updateLogStatus",
        config: {
            auth: false,
            policies: [],
            middlewares: [],
        },
    },
    {
        method: "GET",
        path: "/payment-log/all",
        handler: "payment-log.findAllLogs",
        config: {
            auth: false,
            policies: [],
            middlewares: [],
        },
    },
    {
        method: "POST",
        path: "/syncSalesData",
        handler: "payment-log.syncSalesData",
        config: {
            auth: false,
            policies: [],
            middlewares: [],
        },
    },
];
exports.default = customRouter(defaultRouter, extraRoutes);
