"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const strapi_1 = require("@strapi/strapi");
exports.default = strapi_1.factories.createCoreController("api::redeem-link.redeem-link", ({ strapi }) => ({
    findAllRedeemLinks: async (ctx) => {
        try {
            const data = await strapi
                .service("api::redeem-link.redeem-link")
                .findAllRedeemLinks(ctx.request.query);
            return ctx.send(data);
        }
        catch (error) {
            console.log(error);
        }
    },
    createRedeemLink: async (ctx) => {
        try {
            const data = await strapi
                .service("api::redeem-link.redeem-link")
                .createRedeemLink(ctx.request.body);
            return ctx.send(data);
        }
        catch (error) {
            console.log(error);
        }
    },
    updateRedeemLink: async (ctx) => {
        try {
            const { id } = ctx.params;
            if (!id) {
                return ctx.badRequest("ID is required");
            }
            const data = await strapi
                .service("api::redeem-link.redeem-link")
                .updateRedeemLink(id, ctx.request.body);
            return ctx.send(data);
        }
        catch (error) {
            console.log(error);
        }
    },
    softDelete: async (ctx) => {
        try {
            const { id } = ctx.params;
            if (!id) {
                return ctx.badRequest("ID is required");
            }
            const data = await strapi
                .service("api::redeem-link.redeem-link")
                .softDelete(id);
            return ctx.send(data);
        }
        catch (error) {
            console.log(error);
        }
    },
}));
