"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const strapi_1 = require("@strapi/strapi");
const defaultRouter = strapi_1.factories.createCoreRouter('api::redeem-link.redeem-link');
const customRouter = (innerRouter, extraRoutes = []) => {
    let routes;
    return {
        get prefix() {
            return innerRouter.prefix;
        },
        get routes() {
            if (!routes)
                routes = innerRouter.routes.concat(extraRoutes);
            return routes;
        },
    };
};
const extraRoutes = [
    {
        method: "GET",
        path: "/redeem-link/all",
        handler: "redeem-link.findAllRedeemLinks",
        config: {
            auth: false,
            policies: [],
            middlewares: [],
        },
    },
    {
        method: "GET",
        path: "/redeem-link/remove/:id",
        handler: "redeem-link.softDelete",
        config: {
            auth: false,
            policies: [],
            middlewares: [],
        },
    },
    {
        method: "POST",
        path: "/redeem-link/create",
        handler: "redeem-link.createRedeemLink",
        config: {
            auth: false,
            policies: [],
            middlewares: [],
        },
    },
    {
        method: "PUT",
        path: "/redeem-link/update/:id",
        handler: "redeem-link.updateRedeemLink",
        config: {
            auth: false,
            policies: [],
            middlewares: [],
        },
    },
];
exports.default = customRouter(defaultRouter, extraRoutes);
