"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const strapi_1 = require("@strapi/strapi");
const dataResponse_dto_1 = require("../../../shared/dto/dataResponse.dto");
const jwt = require("jsonwebtoken");
const { v4: uuidv4 } = require("uuid");
async function generateOrderNum(type) {
    try {
        const uuid = uuidv4();
        const base36 = parseInt(uuid.replace(/-/g, ""), 16).toString(36);
        let firstLetter = type === "others" ? "O" : "S";
        const orderNumber = firstLetter + base36.slice(0, 7).toUpperCase();
        const isOrderNumberExists = await strapi.db
            .query("api::order.order")
            .findOne({
            where: { orderId: orderNumber, is_deleted: false },
        });
        if (isOrderNumberExists)
            return await generateOrderNum(type);
        return orderNumber;
    }
    catch (error) {
        console.log("error in generating order number", error);
    }
}
exports.default = strapi_1.factories.createCoreService("api::redeem-link.redeem-link", ({ strapi }) => ({
    async findAllRedeemLinks(params) {
        try {
            const { page, pageSize, search, filters } = params;
            let limit = Number(pageSize) || 10;
            let pageNumber = Number(page) || 1;
            const offset = (Number(pageNumber) - 1) * Number(limit);
            const queryOptions = {
                where: {
                    is_deleted: false,
                    ...(filters && Object.keys(filters).length > 0 && { ...filters }),
                    ...(search &&
                        search.trim().length && {
                        $or: [
                            { title: { $containsi: search } }
                        ],
                    }),
                },
                populate: {
                    ticket_type: {
                        select: ["id", "title", "id_short"]
                    },
                    creator: {
                        select: ["username", "firstName", "lastName"]
                    },
                },
                offset,
                limit: limit,
                orderBy: { createdAt: "desc" },
            };
            const data = await strapi.db.query("api::redeem-link.redeem-link").findMany(queryOptions);
            if (data) {
                const totalDataCount = await strapi
                    .query("api::redeem-link.redeem-link")
                    .count(queryOptions);
                const pageCount = Math.ceil(totalDataCount / limit);
                return new dataResponse_dto_1.DataResponseDto({
                    data,
                    pagination: {
                        page: Number(pageNumber),
                        pageSize: Number(limit),
                        pageCount,
                        total: totalDataCount,
                    },
                }, "redeem-link data fetched successfully");
            }
            else {
                return new dataResponse_dto_1.DataResponseDto(null);
            }
        }
        catch (error) {
            console.log(error);
            return new dataResponse_dto_1.DataResponseDto(null, "Something went wrong in our end please contact system administrator");
        }
    },
    async createRedeemLink(body) {
        try {
            const result = await strapi.db.transaction(async ({ trx }) => {
                var _a, _b, _c, _d;
                const uniqueCode = await strapi.db.query("api::redeem-link.redeem-link").findMany({
                    where: {
                        title: body === null || body === void 0 ? void 0 : body.title.trim(),
                        is_deleted: false,
                    },
                });
                if (uniqueCode.length) {
                    return new dataResponse_dto_1.DataResponseDto(null, "Redeem link with same title already exists");
                }
                const obj = {
                    title: body === null || body === void 0 ? void 0 : body.title,
                    url: "",
                    ticket_type: body === null || body === void 0 ? void 0 : body.ticket_type,
                    total_max_limit: body === null || body === void 0 ? void 0 : body.total_max_limit,
                    total_remaining_count: body === null || body === void 0 ? void 0 : body.total_max_limit,
                    resolve_max_limit: (body === null || body === void 0 ? void 0 : body.resolve_max_limit) || 0,
                    resolve_remaining_count: (body === null || body === void 0 ? void 0 : body.resolve_max_limit) || 0,
                    asset_max_limit: (body === null || body === void 0 ? void 0 : body.asset_max_limit) || 0,
                    asset_remaining_count: (body === null || body === void 0 ? void 0 : body.asset_max_limit) || 0,
                    fintech_max_limit: (body === null || body === void 0 ? void 0 : body.fintech_max_limit) || 0,
                    fintech_remaining_count: (body === null || body === void 0 ? void 0 : body.fintech_max_limit) || 0,
                    adsff_max_limit: (body === null || body === void 0 ? void 0 : body.adsff_max_limit) || 0,
                    adsff_remaining_count: (body === null || body === void 0 ? void 0 : body.adsff_max_limit) || 0,
                    description: body === null || body === void 0 ? void 0 : body.description,
                    status: (body === null || body === void 0 ? void 0 : body.status) || true,
                    publishedAt: new Date(),
                    creator: body === null || body === void 0 ? void 0 : body.userId
                };
                const data = await strapi.entityService.create("api::redeem-link.redeem-link", {
                    data: obj,
                    populate: {
                        ticket_type: true,
                    },
                    transacting: trx,
                });
                let generatedOrderNumber = await generateOrderNum("others");
                const order = await strapi.entityService.create("api::order.order", {
                    data: {
                        orderId: generatedOrderNumber,
                        type: "others",
                        paymentId: null,
                        eventDate: new Date(),
                        firstName: body === null || body === void 0 ? void 0 : body.name,
                        lastName: "",
                        email: body === null || body === void 0 ? void 0 : body.email,
                        ticketCount: body === null || body === void 0 ? void 0 : body.total_max_limit,
                        discountAmount: 0,
                        totalAmount: 0,
                        paidAmount: 0,
                        is_discounted: false,
                        publishedAt: new Date(),
                        utm_source: (body === null || body === void 0 ? void 0 : body.utm_source) || "",
                        utm_medium: (body === null || body === void 0 ? void 0 : body.utm_medium) || "",
                        utm_campaign: (body === null || body === void 0 ? void 0 : body.utm_campaign) || "",
                        utm_content: (body === null || body === void 0 ? void 0 : body.utm_content) || "",
                        utm_id: (body === null || body === void 0 ? void 0 : body.utm_id) || "",
                        status: "Free",
                        userType: "redeem-link",
                        modifiedBy: body === null || body === void 0 ? void 0 : body.userId
                    },
                });
                const secret = process.env.EVENTO_JWT_SECRET;
                const jwtPayload = {
                    ticketType: (_a = data === null || data === void 0 ? void 0 : data.ticket_type) === null || _a === void 0 ? void 0 : _a.id_short,
                    ticketId: (_b = data === null || data === void 0 ? void 0 : data.ticket_type) === null || _b === void 0 ? void 0 : _b.id,
                    ticketName: (_c = data === null || data === void 0 ? void 0 : data.ticket_type) === null || _c === void 0 ? void 0 : _c.title,
                    redeemId: data === null || data === void 0 ? void 0 : data.id,
                    google_tag: (_d = data === null || data === void 0 ? void 0 : data.ticket_type) === null || _d === void 0 ? void 0 : _d.google_tag,
                    orderNumber: order === null || order === void 0 ? void 0 : order.orderId,
                    orderId: order === null || order === void 0 ? void 0 : order.id,
                };
                const token = jwt.sign(jwtPayload, secret);
                let url = `${process.env.WEB_URL}redeem-link?ticket_details=${token}`;
                await strapi.entityService.update("api::redeem-link.redeem-link", data.id, {
                    data: {
                        url,
                        orderId: order.id,
                        orderNumber: order.orderId,
                    },
                    transacting: trx,
                });
                return new dataResponse_dto_1.DataResponseDto(data, "redeem-link created successfully");
            });
            return result;
        }
        catch (error) {
            console.log(error);
            return new dataResponse_dto_1.DataResponseDto(null, "Something went wrong in our end please contact system administrator");
        }
    },
    async updateRedeemLink(id, body) {
        var _a, _b;
        try {
            const redeemLinkData = await strapi.db
                .query("api::redeem-link.redeem-link")
                .findOne({
                where: { id, is_deleted: false },
                populate: true,
            });
            if (!redeemLinkData) {
                return new dataResponse_dto_1.DataResponseDto(null, "redeem-link not found");
            }
            ;
            const uniqueCode = await strapi.db.query("api::redeem-link.redeem-link").findMany({
                where: {
                    title: body === null || body === void 0 ? void 0 : body.title.trim(),
                    is_deleted: false,
                    id: {
                        $ne: id
                    }
                },
            });
            if (uniqueCode.length) {
                return new dataResponse_dto_1.DataResponseDto(null, "Redeem link with same title already exists");
            }
            if ((((_a = redeemLinkData === null || redeemLinkData === void 0 ? void 0 : redeemLinkData.ticket_type) === null || _a === void 0 ? void 0 : _a.id) != (body === null || body === void 0 ? void 0 : body.ticket_type)) && (redeemLinkData.total_max_limit != redeemLinkData.total_remaining_count)) {
                return new dataResponse_dto_1.DataResponseDto(null, "You can't update the ticket for the redeem link");
            }
            let total_remaining_count = Number(redeemLinkData.total_remaining_count);
            let resolve_remaining_count = Number(redeemLinkData.resolve_remaining_count);
            let asset_remaining_count = Number(redeemLinkData.asset_remaining_count);
            let fintech_remaining_count = Number(redeemLinkData.fintech_remaining_count);
            let adsff_remaining_count = Number(redeemLinkData.adsff_remaining_count);
            // total max limit
            if (body.total_max_limit === 0 || body.total_max_limit) {
                let remaining = Number(redeemLinkData.total_max_limit) -
                    Number(redeemLinkData.total_remaining_count);
                const newTotalMax = body.total_max_limit === 0 ? 0 : body.total_max_limit;
                total_remaining_count = Number(newTotalMax) - Number(remaining);
                if (Number(remaining) > Number(body.total_max_limit)) {
                    return new dataResponse_dto_1.DataResponseDto(null, "total_max_limit cannot be less than redeemed tickets count");
                }
            }
            // resolve max limit
            if (body.resolve_max_limit === 0 || body.resolve_max_limit) {
                let resolve_remaining = Number(redeemLinkData.resolve_max_limit) -
                    Number(redeemLinkData.resolve_remaining_count);
                let newResolveCount = body.resolve_max_limit === 0 ? 0 : Number(body.resolve_max_limit);
                resolve_remaining_count = Number(newResolveCount) - Number(resolve_remaining);
                if (Number(resolve_remaining) > Number(newResolveCount)) {
                    return new dataResponse_dto_1.DataResponseDto(null, "resolve max limit cannot be less than redeemed tickets count");
                }
            }
            // asset max limit
            if (body.asset_max_limit === 0 || body.asset_max_limit) {
                let asset_remaining = Number(redeemLinkData.asset_max_limit) -
                    Number(redeemLinkData.asset_remaining_count);
                let newAssetCount = body.asset_max_limit === 0 ? 0 : Number(body.asset_max_limit);
                asset_remaining_count = Number(newAssetCount) - Number(asset_remaining);
                if (Number(asset_remaining) > Number(newAssetCount)) {
                    return new dataResponse_dto_1.DataResponseDto(null, "asset_max_limit cannot be less than redeemed tickets count");
                }
            }
            // fintech max limit
            if (body.fintech_max_limit === 0 || body.fintech_max_limit) {
                let fintech_remaining = Number(redeemLinkData.fintech_max_limit) -
                    Number(redeemLinkData.fintech_remaining_count);
                let newFintechCount = body.fintech_max_limit === 0 ? 0 : body.fintech_max_limit;
                fintech_remaining_count = Number(newFintechCount) - Number(fintech_remaining);
                if (Number(fintech_remaining) > Number(newFintechCount)) {
                    return new dataResponse_dto_1.DataResponseDto(null, "fintech_max_limit cannot be less than redeemed tickets count");
                }
            }
            // adsff max limit
            if (body.adsff_max_limit === 0 || body.adsff_max_limit) {
                let adsff_remaining = Number(redeemLinkData.adsff_max_limit) -
                    Number(redeemLinkData.adsff_remaining_count);
                let newAdsffCount = body.adsff_max_limit === 0 ? 0 : Number(body.adsff_max_limit);
                adsff_remaining_count = Number(newAdsffCount) - Number(adsff_remaining);
                if (Number(adsff_remaining) > Number(adsff_remaining_count)) {
                    return new dataResponse_dto_1.DataResponseDto(null, "adsff_max_limit cannot be less than redeemed tickets count");
                }
            }
            let url = redeemLinkData.url;
            if ((redeemLinkData === null || redeemLinkData === void 0 ? void 0 : redeemLinkData.ticket_type) !== (body === null || body === void 0 ? void 0 : body.ticket_type)) {
                const ticketType = await strapi.db.query("api::ticket.ticket").findOne({
                    where: { id: body === null || body === void 0 ? void 0 : body.ticket_type, is_deleted: false },
                });
                if (!ticketType) {
                    return new dataResponse_dto_1.DataResponseDto(null, "Ticket type is not found");
                }
                const secret = process.env.EVENTO_JWT_SECRET;
                const jwtPayload = {
                    ticketType: ticketType === null || ticketType === void 0 ? void 0 : ticketType.id_short,
                    ticketId: ticketType === null || ticketType === void 0 ? void 0 : ticketType.id,
                    ticketName: ticketType === null || ticketType === void 0 ? void 0 : ticketType.title,
                    redeemId: redeemLinkData === null || redeemLinkData === void 0 ? void 0 : redeemLinkData.id,
                    google_tag: ticketType === null || ticketType === void 0 ? void 0 : ticketType.google_tag,
                    orderNumber: redeemLinkData === null || redeemLinkData === void 0 ? void 0 : redeemLinkData.orderNumber,
                    orderId: (_b = redeemLinkData === null || redeemLinkData === void 0 ? void 0 : redeemLinkData.orderId) === null || _b === void 0 ? void 0 : _b.id,
                };
                const token = jwt.sign(jwtPayload, secret);
                url = `${process.env.WEB_URL}redeem-link?ticket_details=${token}`;
            }
            const obj = {
                title: body === null || body === void 0 ? void 0 : body.title,
                ticket_type: body === null || body === void 0 ? void 0 : body.ticket_type,
                total_max_limit: body === null || body === void 0 ? void 0 : body.total_max_limit,
                resolve_max_limit: body === null || body === void 0 ? void 0 : body.resolve_max_limit,
                asset_max_limit: body === null || body === void 0 ? void 0 : body.asset_max_limit,
                fintech_max_limit: body === null || body === void 0 ? void 0 : body.fintech_max_limit,
                adsff_max_limit: body === null || body === void 0 ? void 0 : body.adsff_max_limit,
                description: body === null || body === void 0 ? void 0 : body.description,
                status: body === null || body === void 0 ? void 0 : body.status,
                url: url,
                total_remaining_count: Number(total_remaining_count),
                resolve_remaining_count: Number(resolve_remaining_count),
                asset_remaining_count: Number(asset_remaining_count),
                fintech_remaining_count: Number(fintech_remaining_count),
                adsff_remaining_count: Number(adsff_remaining_count),
                modifiedBy: body === null || body === void 0 ? void 0 : body.userId
            };
            const data = await strapi.entityService.update("api::redeem-link.redeem-link", id, {
                data: obj,
            });
            if (Number(body === null || body === void 0 ? void 0 : body.total_max_limit) !==
                Number(redeemLinkData.total_max_limit)) {
                await strapi.entityService.update("api::order.order", redeemLinkData.orderId.id, {
                    data: {
                        ticketCount: body === null || body === void 0 ? void 0 : body.total_max_limit,
                        modifiedBy: body === null || body === void 0 ? void 0 : body.userId,
                    },
                });
            }
            return new dataResponse_dto_1.DataResponseDto(data, "redeem-link updated successfully");
        }
        catch (error) {
            console.log(error);
            return new dataResponse_dto_1.DataResponseDto(null, "Something went wrong in our end please contact system administrator");
        }
    },
    async softDelete(id) {
        try {
            const data = await strapi.db
                .query("api::redeem-link.redeem-link")
                .update({
                where: { id, is_deleted: false },
                data: {
                    is_deleted: true,
                    status: false,
                },
            });
            if (data) {
                return new dataResponse_dto_1.DataResponseDto(data, "redeem-link deleted successfully");
            }
            else {
                return new dataResponse_dto_1.DataResponseDto(null);
            }
        }
        catch (error) {
            console.log(error);
            return new dataResponse_dto_1.DataResponseDto(null, "Something went wrong in our end please contact system administrator");
        }
    },
}));
