"use strict";
/**
 * restaurant controller
 */
Object.defineProperty(exports, "__esModule", { value: true });
const strapi_1 = require("@strapi/strapi");
exports.default = strapi_1.factories.createCoreController("api::restaurant.restaurant", ({ strapi }) => ({
    createRestaurantMenus: async (ctx) => {
        try {
            const data = await strapi
                .service("api::restaurant.restaurant")
                .createRestaurantMenus(ctx.request.body);
            return ctx.send(data);
        }
        catch (error) {
            console.log(error);
        }
    },
    async updateRestaurantMenus(ctx) {
        try {
            const { id } = ctx.params; // Get restaurant id from the request params
            const body = ctx.request.body; // Get the body payload
            if (!id || !(body === null || body === void 0 ? void 0 : body.userId) || !(body === null || body === void 0 ? void 0 : body.items)) {
                return ctx.badRequest("Provide all required fields");
            }
            const result = await strapi
                .service("api::restaurant.restaurant")
                .updateRestaurantMenus(id, body);
            if (!result.data) {
                return ctx.notFound(result.message);
            }
            return ctx.send(result);
        }
        catch (error) {
            console.error(error);
            return ctx.internalServerError("Something went wrong on our end, please contact the system administrator");
        }
    },
    softDelete: async (ctx) => {
        try {
            const { id } = ctx.params;
            if (!id) {
                return ctx.badRequest("ID is required");
            }
            const data = await strapi
                .service("api::restaurant.restaurant")
                .softDelete(id);
            return ctx.send(data);
        }
        catch (error) {
            console.log(error);
        }
    },
    findAllItems: async (ctx) => {
        try {
            const { id } = ctx.params;
            if (!id) {
                return ctx.badRequest("ID is required");
            }
            const data = await strapi
                .service("api::restaurant.restaurant")
                .findAllItems(id, ctx.request.query);
            return ctx.send(data);
        }
        catch (error) {
            console.log(error);
        }
    },
    findAllByLocation: async (ctx) => {
        try {
            const data = await strapi
                .service("api::restaurant.restaurant")
                .findAllByLocation(ctx.request.query);
            return ctx.send(data);
        }
        catch (error) {
            console.log(error);
        }
    },
    findAllByLocationApp: async (ctx) => {
        try {
            const data = await strapi
                .service("api::restaurant.restaurant")
                .findAllByLocationApp(ctx.request.query);
            return ctx.send(data);
        }
        catch (error) {
            console.log(error);
        }
    },
    findAllRestaurants: async (ctx) => {
        try {
            const data = await strapi
                .service("api::restaurant.restaurant")
                .findAllRestaurants(ctx.request.query);
            return ctx.send(data);
        }
        catch (error) {
            console.log(error);
        }
    },
}));
