"use strict";
/**
 * restaurant router
 */
Object.defineProperty(exports, "__esModule", { value: true });
const strapi_1 = require("@strapi/strapi");
const defaultRouter = strapi_1.factories.createCoreRouter("api::restaurant.restaurant");
const customRouter = (innerRouter, extraRoutes = []) => {
    let routes;
    return {
        get prefix() {
            return innerRouter.prefix;
        },
        get routes() {
            if (!routes)
                routes = innerRouter.routes.concat(extraRoutes);
            return routes;
        },
    };
};
const extraRoutes = [
    {
        method: "POST",
        path: "/createRestaurant",
        handler: "restaurant.createRestaurantMenus",
        config: {
            policies: [],
            middlewares: [],
        },
    },
    {
        method: "PUT",
        path: "/restaurants/menus/:id",
        handler: "restaurant.updateRestaurantMenus",
        config: {
            policies: [],
            middlewares: [],
        },
    },
    {
        method: "GET",
        path: "/restaurant/remove/:id",
        handler: "restaurant.softDelete",
        config: {
            auth: false,
            policies: [],
            middlewares: [],
        },
    },
    {
        method: "GET",
        path: "/restaurant/findAllItems/:id",
        handler: "restaurant.findAllItems",
        config: {
            auth: false,
            policies: [],
            middlewares: [],
        },
    },
    {
        method: "GET",
        path: "/restaurant/byLocation",
        handler: "restaurant.findAllByLocation",
        config: {
            auth: false,
            policies: [],
            middlewares: [],
        },
    },
    {
        method: "GET",
        path: "/restaurant/findAllByLocation",
        handler: "restaurant.findAllByLocationApp",
        config: {
            auth: false,
            policies: [],
            middlewares: [],
        },
    },
    {
        method: "GET",
        path: "/restaurant/all",
        handler: "restaurant.findAllRestaurants",
        config: {
            auth: false,
            policies: [],
            middlewares: [],
        },
    },
];
exports.default = customRouter(defaultRouter, extraRoutes);
