"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const strapi_1 = require("@strapi/strapi");
exports.default = strapi_1.factories.createCoreController("api::speaker-invitation.speaker-invitation", ({ strapi }) => ({
    bulkCreate: async (ctx) => {
        try {
            const data = await strapi
                .service("api::speaker-invitation.speaker-invitation")
                .bulkCreate(ctx.request.body);
            return ctx.send(data);
        }
        catch (error) {
            console.log(error);
        }
    },
    softDelete: async (ctx) => {
        try {
            const { id } = ctx.params;
            if (!id) {
                return ctx.badRequest("ID is required");
            }
            const data = await strapi
                .service("api::speaker-invitation.speaker-invitation")
                .softDelete(id);
            return ctx.send(data);
        }
        catch (error) {
            console.log(error);
        }
    },
    findAllInvitations: async (ctx) => {
        try {
            const data = await strapi
                .service("api::speaker-invitation.speaker-invitation")
                .findAllInvitations(ctx.request.query);
            return ctx.send(data);
        }
        catch (error) {
            console.log(error);
        }
    },
    findExportData: async (ctx) => {
        try {
            const data = await strapi
                .service("api::speaker-invitation.speaker-invitation")
                .findExportData();
            return ctx.send(data);
        }
        catch (error) {
            console.log(error);
        }
    },
    findStatusData: async (ctx) => {
        try {
            const data = await strapi
                .service("api::speaker-invitation.speaker-invitation")
                .findStatusData();
            return ctx.send(data);
        }
        catch (error) {
            console.log(error);
        }
    },
    syncSpeakerData: async (ctx) => {
        try {
            const { userId } = ctx.request.query;
            const data = await strapi
                .service("api::speaker-invitation.speaker-invitation")
                .syncSpeakerData(userId);
            return ctx.send(data);
        }
        catch (error) {
            console.log(error);
        }
    },
}));
