"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const strapi_1 = require("@strapi/strapi");
const defaultRouter = strapi_1.factories.createCoreRouter('api::speaker-invitation.speaker-invitation');
const customRouter = (innerRouter, extraRoutes = []) => {
    let routes;
    return {
        get prefix() {
            return innerRouter.prefix;
        },
        get routes() {
            if (!routes)
                routes = innerRouter.routes.concat(extraRoutes);
            return routes;
        },
    };
};
const extraRoutes = [
    {
        method: "POST",
        path: "/speaker-invitations/bulk-create",
        handler: "speaker-invitation.bulkCreate",
        config: {
            auth: false,
            policies: [],
            middlewares: [],
        },
    },
    {
        method: "GET",
        path: "/speaker-invitations/remove/:id",
        handler: "speaker-invitation.softDelete",
        config: {
            auth: false,
            policies: [],
            middlewares: [],
        },
    },
    {
        method: "GET",
        path: "/speaker-invitation/all",
        handler: "speaker-invitation.findAllInvitations",
        config: {
            auth: false,
            policies: [],
            middlewares: [],
        }
    },
    {
        method: "GET",
        path: "/speaker-invitation/export",
        handler: "speaker-invitation.findExportData",
        config: {
            auth: false,
            policies: [],
            middlewares: [],
        }
    },
    {
        method: "GET",
        path: "/speaker-invitation/status",
        handler: "speaker-invitation.findStatusData",
        config: {
            auth: false,
            policies: [],
            middlewares: [],
        }
    },
    {
        method: "GET",
        path: "/speaker-invitation/sync-data",
        handler: "speaker-invitation.syncSpeakerData",
        config: {
            auth: false,
            policies: [],
            middlewares: [],
        }
    },
];
exports.default = customRouter(defaultRouter, extraRoutes);
