"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const strapi_1 = require("@strapi/strapi");
const dataResponse_dto_1 = require("../../../shared/dto/dataResponse.dto");
exports.default = strapi_1.factories.createCoreService("api::speaker-invitation.speaker-invitation", ({ strapi }) => ({
    async findExportData() {
        try {
            const data = await strapi.db
                .query("api::speaker-invitation.speaker-invitation")
                .findMany({
                where: { is_deleted: false },
                orderBy: { id: "desc" },
            });
            return new dataResponse_dto_1.DataResponseDto(data, "Speaker invitation data fetched successfully");
        }
        catch (error) {
            console.log(error);
            return new dataResponse_dto_1.DataResponseDto(null, "Something went wrong in our end please contact system administrator");
        }
    },
    async syncSpeakerData(userId) {
        try {
            const nonAcceptedSpeakers = await strapi.db
                .query("api::speaker-invitation.speaker-invitation")
                .findMany({
                where: { is_deleted: false, is_accepted: false },
            });
            const speakers = await strapi.db
                .query("api::speaker.speaker")
                .findMany({
                where: { is_deleted: false },
            });
            for (const item of nonAcceptedSpeakers) {
                const speaker = speakers.find((s) => s.email === item.email);
                if (speaker) {
                    await strapi.db
                        .query("api::speaker-invitation.speaker-invitation")
                        .update({
                        where: { email: item.email },
                        data: { is_accepted: true, modifiedBy: userId },
                    });
                }
            }
            return new dataResponse_dto_1.DataResponseDto("success", "Data synced successfully");
        }
        catch (error) {
            console.log(error);
            return new dataResponse_dto_1.DataResponseDto(null, "Something went wrong in our end please contact system administrator");
        }
    },
    async findStatusData() {
        try {
            const nonAcceptedCount = await strapi.db
                .query("api::speaker-invitation.speaker-invitation")
                .count({
                where: { is_deleted: false, is_accepted: false },
            });
            const acceptedCount = await strapi.db
                .query("api::speaker-invitation.speaker-invitation")
                .count({
                where: { is_deleted: false, is_accepted: true },
            });
            return new dataResponse_dto_1.DataResponseDto({
                nonAcceptedCount: nonAcceptedCount || 0,
                acceptedCount: acceptedCount || 0,
                total: Number(nonAcceptedCount) + Number(acceptedCount),
            }, "Speaker invitation data fetched successfully");
        }
        catch (error) {
            console.log(error);
            return new dataResponse_dto_1.DataResponseDto(null, "Something went wrong in our end please contact system administrator");
        }
    },
    async findAllInvitations(params) {
        try {
            const { page, pageSize, search, filters } = params;
            let limit = Number(pageSize) || 10;
            let pageNumber = Number(page) || 1;
            const offset = (Number(pageNumber) - 1) * Number(limit);
            const where = {
                is_deleted: false,
                ...(filters && Object.keys(filters).length > 0 && { ...filters }),
                ...(search &&
                    search.trim().length && {
                    $or: [
                        { firstName: { $containsi: search } },
                        { lastName: { $containsi: search } },
                        { email: { $containsi: search } },
                    ],
                }),
            };
            const data = await strapi.db
                .query("api::speaker-invitation.speaker-invitation")
                .findMany({
                where,
                offset,
                limit: limit,
                orderBy: { id: "desc" },
            });
            if (data) {
                const totalDataCount = await strapi
                    .query("api::speaker-invitation.speaker-invitation")
                    .count({ where });
                const pageCount = Math.ceil(totalDataCount / limit);
                return new dataResponse_dto_1.DataResponseDto({
                    data,
                    pagination: {
                        page: Number(pageNumber),
                        pageSize: Number(limit),
                        pageCount,
                        total: totalDataCount,
                    },
                }, "speaker-invitation data fetched successfully");
            }
            else {
                return new dataResponse_dto_1.DataResponseDto(null);
            }
        }
        catch (error) {
            console.log(error);
            return new dataResponse_dto_1.DataResponseDto(null, "Something went wrong in our end please contact system administrator");
        }
    },
    async bulkCreate(body) {
        try {
            const data = await strapi.db
                .query("api::speaker-invitation.speaker-invitation")
                .createMany({
                data: body === null || body === void 0 ? void 0 : body.data,
            });
            return new dataResponse_dto_1.DataResponseDto(data, "Speaker invitation created successfully");
        }
        catch (error) {
            console.log(error);
            return new dataResponse_dto_1.DataResponseDto(null, "Something went wrong in our end please contact system administrator");
        }
    },
    async softDelete(id) {
        try {
            const data = await strapi.db
                .query("api::speaker-invitation.speaker-invitation")
                .update({
                where: { id, is_deleted: false },
                data: {
                    is_deleted: true,
                },
            });
            if (data) {
                return new dataResponse_dto_1.DataResponseDto(data, "Speaker invitayion deleted successfully");
            }
            else {
                return new dataResponse_dto_1.DataResponseDto(null);
            }
        }
        catch (error) {
            console.log(error);
            return new dataResponse_dto_1.DataResponseDto(null, "Something went wrong in our end please contact system administrator");
        }
    },
}));
