"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const strapi_1 = require("@strapi/strapi");
const defaultRouter = strapi_1.factories.createCoreRouter("api::speaker.speaker");
const customRouter = (innerRouter, extraRoutes = []) => {
    let routes;
    return {
        get prefix() {
            return innerRouter.prefix;
        },
        get routes() {
            if (!routes)
                routes = innerRouter.routes.concat(extraRoutes);
            return routes;
        },
    };
};
const extraRoutes = [
    {
        method: "GET",
        path: "/speaker/all",
        handler: "speaker.findAllSpeakers",
        config: {
            auth: false,
            policies: [],
            middlewares: [],
        },
    },
    {
        method: "GET",
        path: "/speaker/export",
        handler: "speaker.findExportData",
        config: {
            auth: false,
            policies: [],
            middlewares: [],
        },
    },
    {
        method: "GET",
        path: "/speaker/picker",
        handler: "api::speaker.speaker.picker",
        config: {
            auth: false,
            policies: [],
            middlewares: [],
        },
    },
    {
        method: "GET",
        path: "/speaker/latestSpeakers",
        handler: "speaker.latestSpeakers",
        config: {
            auth: false,
            policies: [],
            middlewares: [],
        },
    },
    {
        method: "GET",
        path: "/speakers/remove/:id",
        handler: "speaker.softDelete",
        config: {
            auth: false,
            policies: [],
            middlewares: [],
        },
    },
    {
        method: "POST",
        path: "/speakers/login",
        handler: "speaker.speakerLogin",
        config: {
            auth: false,
            policies: [],
            middlewares: [],
        },
    },
    {
        method: "PUT",
        path: "/speakers/updateSpeaker/:id",
        handler: "speaker.updateSpeakerTicketDetails",
        config: {
            policies: [],
            middlewares: [],
        },
    },
    {
        method: "POST",
        path: "/speakers/createSpeaker",
        handler: "speaker.createSpeaker",
        config: {
            policies: [],
            middlewares: [],
        },
    },
];
exports.default = customRouter(defaultRouter, extraRoutes);
