"use strict";
/**
 * sponsor controller
 */
Object.defineProperty(exports, "__esModule", { value: true });
const strapi_1 = require("@strapi/strapi");
exports.default = strapi_1.factories.createCoreController("api::sponsor.sponsor", ({ strapi }) => ({
    async createSponsor(ctx, next) {
        try {
            const data = await strapi
                .service("api::sponsor.sponsor")
                .createSponsor(ctx.request.body);
            return ctx.send(data);
        }
        catch (error) {
            console.log(error);
            return error;
        }
    },
    async updateSponsor(ctx, next) {
        try {
            const { id } = ctx.params;
            if (!id) {
                return ctx.badRequest("ID is required");
            }
            const data = await strapi
                .service("api::sponsor.sponsor")
                .updateSponsor(String(id), ctx.request.body);
            return ctx.send(data);
        }
        catch (error) {
            console.log(error);
            return error;
        }
    },
    findAllSponsors: async (ctx) => {
        try {
            const data = await strapi
                .service("api::sponsor.sponsor")
                .findAllSponsors(ctx.request.query);
            return ctx.send(data);
        }
        catch (error) {
            console.log(error);
        }
    },
    findExportData: async (ctx) => {
        try {
            const data = await strapi
                .service("api::sponsor.sponsor")
                .findExportData();
            return ctx.send(data);
        }
        catch (error) {
            console.log(error);
        }
    },
    getByUUID: async (ctx) => {
        try {
            const { id } = ctx.params;
            if (!id) {
                return ctx.badRequest("ID is required");
            }
            const data = await strapi
                .service("api::sponsor.sponsor")
                .getByUUID(String(id));
            return ctx.send(data);
        }
        catch (error) {
            console.log(error);
        }
    },
    softDelete: async (ctx) => {
        const { id } = ctx.params;
        if (!id) {
            return ctx.badRequest("ID is required");
        }
        try {
            const data = await strapi
                .service("api::sponsor.sponsor")
                .softDelete(id);
            return ctx.send(data);
        }
        catch (error) {
            console.log(error);
        }
    },
    sponsorLogin: async (ctx) => {
        try {
            const data = await strapi
                .service("api::sponsor.sponsor")
                .sponsorLogin(ctx.request.body);
            return ctx.send(data);
        }
        catch (error) {
            console.log(error);
        }
    },
    generateOrderNum: async (ctx) => {
        try {
            const data = await strapi
                .service("api::sponsor.sponsor")
                .generateOrderNum();
            return ctx.send(data);
        }
        catch (error) {
            console.log(error);
        }
    },
}));
