"use strict";
/**
 * sponsor router
 */
Object.defineProperty(exports, "__esModule", { value: true });
const strapi_1 = require("@strapi/strapi");
const defaultRouter = strapi_1.factories.createCoreRouter("api::sponsor.sponsor");
const customRouter = (innerRouter, extraRoutes = []) => {
    let routes;
    return {
        get prefix() {
            return innerRouter.prefix;
        },
        get routes() {
            if (!routes)
                routes = innerRouter.routes.concat(extraRoutes);
            return routes;
        },
    };
};
const extraRoutes = [
    {
        method: "POST",
        path: "/createSponsor",
        handler: "sponsor.createSponsor",
        config: {
            policies: [],
            middlewares: [],
        },
    },
    {
        method: "PUT",
        path: "/updateSponsor/:id",
        handler: "sponsor.updateSponsor",
        config: {
            policies: [],
            middlewares: [],
        },
    },
    {
        method: "GET",
        path: "/sponsors/getByUUID/:id",
        handler: "api::sponsor.sponsor.getByUUID",
        config: {
            auth: false,
            policies: [],
            middlewares: [],
        },
    },
    {
        method: "GET",
        path: "/sponsor/all",
        handler: "sponsor.findAllSponsors",
        config: {
            auth: false,
            policies: [],
            middlewares: [],
        },
    },
    {
        method: "GET",
        path: "/sponsor/export",
        handler: "sponsor.findExportData",
        config: {
            auth: false,
            policies: [],
            middlewares: [],
        },
    },
    {
        method: "GET",
        path: "/sponsor/remove/:id",
        handler: "sponsor.softDelete",
        config: {
            auth: false,
            policies: [],
            middlewares: [],
        },
    },
    {
        method: "POST",
        path: "/sponsor/login",
        handler: "sponsor.sponsorLogin",
        config: {
            auth: false,
            policies: [],
            middlewares: [],
        },
    },
    {
        method: "GET",
        path: "/generateOrderNum",
        handler: "sponsor.generateOrderNum",
        config: {
            auth: false,
            policies: [],
            middlewares: [],
        },
    },
];
exports.default = customRouter(defaultRouter, extraRoutes);
